/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.loading;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.Effect;
import net.sf.hale.area.Area;
import net.sf.hale.entity.Entity;
import net.sf.hale.util.Logger;

public class ReferenceHandler {
    private Map<String, Area> areaRefs = new HashMap<String, Area>();
    private Map<String, Entity> entityRefs = new HashMap<String, Entity>();
    private Map<String, Effect> effectRefs = new HashMap<String, Effect>();
    private Map<String, AbilitySlot> slotRefs = new HashMap<String, AbilitySlot>();
    private Map<Effect, List<String>> effectsWithChildren = new HashMap<Effect, List<String>>();
    private Map<Effect, String> effectSlotReferences = new HashMap<Effect, String>();
    private Map<AbilitySlot, List<String>> slotChildren = new HashMap<AbilitySlot, List<String>>();

    public void addChildEffect(Effect effect, String string) {
        List<String> list = this.effectsWithChildren.get(effect);
        if (list == null) {
            list = new ArrayList<String>();
            this.effectsWithChildren.put(effect, list);
        }
        list.add(string);
    }

    public void addEffectReference(AbilitySlot abilitySlot, String string) {
        List<String> list = this.slotChildren.get(abilitySlot);
        if (list == null) {
            list = new ArrayList<String>();
            this.slotChildren.put(abilitySlot, list);
        }
        list.add(string);
    }

    public void addSlotReference(Effect effect, String string) {
        this.effectSlotReferences.put(effect, string);
    }

    public void resolveAllReferences() {
        Object object;
        for (Effect saveable : this.effectsWithChildren.keySet()) {
            for (String string : this.effectsWithChildren.get(saveable)) {
                Effect effect = this.effectRefs.get(string);
                if (effect == null) {
                    Logger.appendToErrorLog("Error resolving reference for child effect " + string);
                    continue;
                }
                saveable.addChildEffect(effect);
            }
        }
        for (Effect effect : this.effectSlotReferences.keySet()) {
            object = this.effectSlotReferences.get(effect);
            AbilitySlot abilitySlot = this.slotRefs.get(object);
            if (abilitySlot == null) {
                Logger.appendToErrorLog("Error resolving reference for ability slot " + object);
                continue;
            }
            effect.setSlot(abilitySlot);
        }
        for (AbilitySlot abilitySlot : this.slotChildren.keySet()) {
            object = new ArrayList<Effect>();
            for (String string : this.slotChildren.get(abilitySlot)) {
                Effect effect = this.effectRefs.get(string);
                if (effect == null) {
                    Logger.appendToErrorLog("Error resolving reference for slot effect " + string);
                    continue;
                }
                object.add((Effect)effect);
            }
            abilitySlot.loadActiveEffects((List<Effect>)object);
        }
    }

    public void add(String string, Area area) {
        this.areaRefs.put(string, area);
    }

    public Area getArea(String string) {
        return this.areaRefs.get(string);
    }

    public void add(String string, Entity entity) {
        this.entityRefs.put(string, entity);
    }

    public Entity getEntity(String string) {
        return this.entityRefs.get(string);
    }

    public void add(String string, Effect effect) {
        this.effectRefs.put(string, effect);
    }

    public Effect getEffect(String string) {
        return this.effectRefs.get(string);
    }

    public void add(String string, AbilitySlot abilitySlot) {
        this.slotRefs.put(string, abilitySlot);
    }

    public AbilitySlot getAbilitySlot(String string) {
        return this.slotRefs.get(string);
    }
}

