/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.loading;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.ProgressBar;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.loading.LoadingTaskList;
import net.sf.hale.resource.Sprite;
import net.sf.hale.util.Point;
import org.lwjgl.opengl.GL11;

public class LoadingWaitPopup
extends PopupWindow {
    private Sprite bgSprite;
    private Point bgSpriteOffset;
    private Label title;
    private Label description;
    private ProgressBar progressBar;
    private int labelBarGap;
    private int titleGap;
    private Content content;
    private LoadingTaskList taskList;
    private String curDescription;

    public LoadingWaitPopup(Widget widget, String string) {
        super(widget);
        this.setCloseOnEscape(false);
        this.setCloseOnClickedOutside(false);
        this.content = new Content();
        this.add(this.content);
        this.title = new Label(string);
        this.title.setTheme("titlelabel");
        this.content.add((Widget)this.title);
        this.description = new Label(" ");
        this.description.setTheme("descriptionlabel");
        this.content.add((Widget)this.description);
        this.progressBar = new ProgressBar();
        this.content.add((Widget)this.progressBar);
    }

    public void setBGSprite(Sprite sprite) {
        this.bgSprite = sprite;
        this.bgSpriteOffset = new Point();
        if (this.bgSprite != null) {
            this.bgSpriteOffset.x = (Game.displayMode.getWidth() - this.bgSprite.getWidth()) / 2;
            this.bgSpriteOffset.y = (Game.displayMode.getHeight() - this.bgSprite.getHeight()) / 2;
        }
    }

    public void setLoadingTaskList(LoadingTaskList loadingTaskList) {
        this.taskList = loadingTaskList;
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.labelBarGap = themeInfo.getParameter("labelBarGap", 0);
        this.titleGap = themeInfo.getParameter("titleGap", 0);
    }

    protected void paint(GUI gUI) {
        super.paint(gUI);
        String string = this.taskList.getCurrentDescription();
        if (string != this.curDescription) {
            this.description.setText(string);
            this.curDescription = string;
        }
        this.progressBar.setValue(this.taskList.getCompletedFraction());
    }

    private class Content
    extends Widget {
        private Content() {
        }

        protected void paintWidget(GUI gUI) {
            if (LoadingWaitPopup.this.bgSprite != null) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                LoadingWaitPopup.this.bgSprite.draw(0, 0, this.getWidth(), this.getHeight());
            }
        }

        protected void layout() {
            int n = this.getInnerX() + this.getInnerWidth() / 2;
            LoadingWaitPopup.this.progressBar.setSize(this.getInnerWidth(), LoadingWaitPopup.this.progressBar.getPreferredHeight());
            LoadingWaitPopup.this.progressBar.setPosition(this.getInnerX(), this.getInnerBottom() - LoadingWaitPopup.this.progressBar.getHeight());
            LoadingWaitPopup.this.description.setSize(LoadingWaitPopup.this.description.getPreferredWidth(), LoadingWaitPopup.this.description.getPreferredHeight());
            LoadingWaitPopup.this.description.setPosition(n - LoadingWaitPopup.this.description.getWidth() / 2, LoadingWaitPopup.this.progressBar.getY() - LoadingWaitPopup.this.labelBarGap - LoadingWaitPopup.this.description.getHeight());
            LoadingWaitPopup.this.title.setSize(LoadingWaitPopup.this.title.getPreferredWidth(), LoadingWaitPopup.this.title.getPreferredHeight());
            LoadingWaitPopup.this.title.setPosition(n - LoadingWaitPopup.this.title.getWidth() / 2, LoadingWaitPopup.this.description.getY() - LoadingWaitPopup.this.titleGap - LoadingWaitPopup.this.title.getHeight());
        }

        public int getPreferredWidth() {
            return Game.displayMode.getWidth();
        }

        public int getPreferredHeight() {
            return Game.displayMode.getHeight();
        }
    }
}

