/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.loading;

import java.util.ArrayList;
import java.util.List;
import net.sf.hale.loading.LoadingTask;
import net.sf.hale.util.Logger;

public class LoadingTaskList
extends Thread {
    private List<LoadingTask> tasks = new ArrayList<LoadingTask>();
    private int totalWeight;
    private float completedFraction;
    private String currentDescription;
    private boolean success;

    public void addTask(LoadingTask loadingTask) {
        this.tasks.add(loadingTask);
        this.totalWeight += loadingTask.getWeight();
        loadingTask.initialize();
    }

    public void addTask(Runnable runnable, String string, int n) {
        this.addTask(new LoadingTask(runnable, string, n));
    }

    public void addTask(Runnable runnable, String string) {
        this.addTask(new LoadingTask(runnable, string));
    }

    public float getCompletedFraction() {
        return this.completedFraction;
    }

    public String getCurrentDescription() {
        return this.currentDescription;
    }

    public boolean isCompletedSuccessfully() {
        return this.success;
    }

    protected void onError() {
    }

    @Override
    public void run() {
        try {
            int n = 0;
            for (LoadingTask loadingTask : this.tasks) {
                this.currentDescription = loadingTask.getDescription();
                while (loadingTask.hasNextTask()) {
                    this.completedFraction = (float)(n += loadingTask.executeNextTask()) / (float)this.totalWeight;
                }
            }
            Thread.sleep(300L);
            this.success = true;
        }
        catch (Exception exception) {
            this.onError();
            Logger.appendToErrorLog("Exception while loading data", exception);
        }
    }
}

