/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.loading;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class LoadingTask {
    private String description;
    private int taskWeight;
    private Runnable task;
    private Iterator<SubTask> subTasksIter;
    private List<SubTask> subTasks;

    public LoadingTask(Runnable runnable, String string) {
        this.task = runnable;
        this.description = string;
        this.taskWeight = 1;
        this.subTasks = new ArrayList<SubTask>();
    }

    public LoadingTask(Runnable runnable, String string, int n) {
        this.task = runnable;
        this.description = string;
        this.taskWeight = n;
        this.subTasks = new ArrayList<SubTask>();
    }

    public void addSubTask(Runnable runnable, int n) {
        SubTask subTask = new SubTask();
        subTask.task = runnable;
        subTask.weight = n;
        this.subTasks.add(subTask);
        this.taskWeight += subTask.weight;
    }

    public int getWeight() {
        return this.taskWeight;
    }

    public String getDescription() {
        return this.description;
    }

    public void initialize() {
        this.subTasksIter = this.subTasks.iterator();
    }

    public int executeNextTask() {
        if (this.task != null) {
            this.task.run();
            this.task = null;
            return this.taskWeight;
        }
        if (this.subTasksIter.hasNext()) {
            SubTask subTask = this.subTasksIter.next();
            subTask.task.run();
            return subTask.weight;
        }
        throw new NoSuchElementException();
    }

    public boolean hasNextTask() {
        return this.task != null || this.subTasksIter.hasNext();
    }

    private class SubTask {
        private Runnable task;
        private int weight;

        private SubTask() {
        }
    }
}

