/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.loading;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import net.sf.hale.Game;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.loading.LoadingTaskList;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SaveFileHeader;
import net.sf.hale.util.SimpleJSONParser;

public class LoadGameLoadingTaskList
extends LoadingTaskList {
    private SimpleJSONParser parser;
    private File fileToLoad;
    private GZIPInputStream gz;

    public LoadGameLoadingTaskList(File file) {
        Object object;
        this.fileToLoad = file;
        try {
            if (Game.curCampaign != null && Game.curCampaign.curArea != null) {
                Game.curCampaign.getTileset(Game.curCampaign.curArea.getTileset()).freeTiles();
            }
            object = new FileInputStream(this.fileToLoad);
            this.gz = new GZIPInputStream((InputStream)object);
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error loading saved game: " + this.fileToLoad.getPath(), exception);
        }
        object = new Runnable(){

            @Override
            public void run() {
                try {
                    SaveFileHeader.read(LoadGameLoadingTaskList.this.gz);
                }
                catch (Exception exception) {
                    Logger.appendToErrorLog("Error loading saved game: " + LoadGameLoadingTaskList.this.fileToLoad.getPath(), exception);
                }
            }
        };
        this.addTask((Runnable)object, "Loading Header Data", 1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(LoadGameLoadingTaskList.this.gz);
                    LoadGameLoadingTaskList.this.parser = new SimpleJSONParser(inputStreamReader, LoadGameLoadingTaskList.this.fileToLoad.getName());
                    LoadGameLoadingTaskList.this.parser.setWarnOnMissingKeys(false);
                }
                catch (Exception exception) {
                    Logger.appendToErrorLog("Error parsing saved game: " + LoadGameLoadingTaskList.this.fileToLoad.getPath(), exception);
                }
            }
        };
        this.addTask(runnable, "Parsing Save Game File", 1);
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                try {
                    EntityManager.clear();
                    Game.curCampaign.load(LoadGameLoadingTaskList.this.parser);
                }
                catch (Exception exception) {
                    Logger.appendToErrorLog("Error loading saved game: " + LoadGameLoadingTaskList.this.fileToLoad.getPath(), exception);
                }
            }
        };
        this.addTask(runnable2, "Loading Game Content", 1);
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                if (Game.isInTurnMode()) {
                    Game.areaListener.getCombatRunner().exitCombat();
                }
                Game.areaViewer.setArea(Game.curCampaign.curArea);
                Game.areaListener.setArea(Game.curCampaign.curArea);
            }
        };
        this.addTask(runnable3, "Loading Tileset", 5);
        Runnable runnable4 = new Runnable(){

            @Override
            public void run() {
                Game.curCampaign.curArea.setEntityVisibility();
                Game.curCampaign.curArea.getUtil().updateVisibility();
                Game.mainViewer.getPortraitArea().updateParty();
                Game.selectedEntity = Game.curCampaign.party.getSelected();
                Game.interfaceLocker.clear();
                System.gc();
            }
        };
        this.addTask(runnable4, "Setting up interface", 2);
    }
}

