/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.loading;

import java.io.File;
import net.sf.hale.Game;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.loading.LoadingTask;
import net.sf.hale.loading.LoadingTaskList;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.rules.Ruleset;

public class CampaignLoadingTaskList
extends LoadingTaskList {
    public CampaignLoadingTaskList() {
        SpriteManager.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ResourceManager.registerCampaignPackage();
            }
        };
        LoadingTask loadingTask = new LoadingTask(null, "Loading Images");
        for (String object2 : ResourceManager.getResourcesInDirectory("images")) {
            if (!object2.endsWith(ResourceType.JSON.getExtension())) continue;
            loadingTask.addSubTask(new SpriteSheetLoader(object2), 10);
        }
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                Game.particleManager.loadBaseResources();
            }
        };
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                Game.ruleset = new Ruleset();
                Game.ruleset.readData();
                EntityManager.clear();
            }
        };
        Runnable runnable4 = new Runnable(){

            @Override
            public void run() {
                Game.curCampaign.readCampaignFile();
                System.gc();
            }
        };
        this.addTask(runnable, "Registering Campaign Resources", 1);
        this.addTask(loadingTask);
        this.addTask(runnable2, "Loading Animations", 5);
        this.addTask(runnable3, "Loading Ruleset", 30);
        this.addTask(runnable4, "Loading Campaign resources", 30);
    }

    @Override
    protected void onError() {
        Game.curCampaign = null;
        File file = new File(Game.getConfigBaseDirectory() + "lastOpenCampaign.txt");
        file.delete();
    }

    private class SpriteSheetLoader
    implements Runnable {
        private String resource;

        private SpriteSheetLoader(String string) {
            this.resource = string;
        }

        @Override
        public void run() {
            SpriteManager.readSpriteSheet(this.resource);
        }
    }
}

