/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.loading;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.resource.Sprite;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class AsyncTextureLoader {
    private List<TextureSpriteLoadList> loadLists = new ArrayList<TextureSpriteLoadList>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<TextureSpriteLoadList> list = this.loadLists;
        synchronized (list) {
            this.loadLists.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        List<TextureSpriteLoadList> list = this.loadLists;
        synchronized (list) {
            for (TextureSpriteLoadList textureSpriteLoadList : this.loadLists) {
                textureSpriteLoadList.loadTexture();
            }
            this.loadLists.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTexture(ByteBuffer byteBuffer, int n, int n2, List<Sprite> list) {
        TextureSpriteLoadList textureSpriteLoadList = new TextureSpriteLoadList(byteBuffer, n, n2, list);
        List<TextureSpriteLoadList> list2 = this.loadLists;
        synchronized (list2) {
            this.loadLists.add(textureSpriteLoadList);
        }
    }

    private class TextureSpriteLoadList {
        private ByteBuffer pixels;
        private int width;
        private int height;
        private List<Sprite> sprites;

        private TextureSpriteLoadList(ByteBuffer byteBuffer, int n, int n2, List<Sprite> list) {
            this.pixels = byteBuffer;
            this.width = n;
            this.height = n2;
            this.sprites = list;
        }

        private void loadTexture() {
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
            GL11.glGenTextures((IntBuffer)intBuffer);
            GL11.glBindTexture((int)3553, (int)intBuffer.get(0));
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.pixels);
            for (Sprite sprite : this.sprites) {
                sprite.setTexture(intBuffer.get(0));
            }
        }
    }
}

