/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.interfacelock;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.CombatRunner;
import net.sf.hale.Game;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.Path;
import net.sf.hale.interfacelock.EntityMovementAnimation;
import net.sf.hale.rules.Faction;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;

public class MovementHandler {
    private Mode mode;
    private List<Mover> moves = new ArrayList<Mover>();
    private boolean interrupted = false;

    public MovementHandler() {
        this.mode = Mode.Party;
    }

    public synchronized void update(long l) {
        Iterator<Mover> iterator = this.moves.iterator();
        while (iterator.hasNext()) {
            Mover mover = iterator.next();
            if (mover.creature.isDead() && (!mover.creature.isPlayerFaction() || Game.isInTurnMode())) {
                mover.finish();
                iterator.remove();
                continue;
            }
            if (!mover.isReadyForMovement(l)) continue;
            if (mover.lastIndex == 0) {
                mover.finish();
                iterator.remove();
                continue;
            }
            mover.performMovement(l);
        }
        if (this.interrupted) {
            this.clear();
            this.interrupted = false;
        }
    }

    public Mode getMovementMode() {
        return this.mode;
    }

    public void setMovementMode(Mode mode) {
        this.mode = mode;
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public boolean isLocked() {
        return this.moves.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mover addMove(Creature creature, Path path, boolean bl) {
        creature.setCurrentlyMoving(true);
        Mover mover = new Mover(creature, path, bl);
        MovementHandler movementHandler = this;
        synchronized (movementHandler) {
            this.moves.add(mover);
        }
        mover.checkAoOsAndAnimate();
        return mover;
    }

    public synchronized void clear() {
        for (Mover mover : this.moves) {
            mover.creature.setCurrentlyMoving(false);
            mover.creature.setOffsetAnimation(null);
        }
        for (Mover mover : this.moves) {
            mover.moveBackToEmptyTile();
            mover.finish();
        }
        this.moves.clear();
    }

    public class Mover {
        private Location initialPosition;
        private Creature creature;
        private Path path;
        private long lastTime;
        private int lastIndex;
        private CombatRunner combatRunner;
        private boolean provokeAoOs;
        private List<Runnable> callbacks;
        private boolean finished;
        private long currentMoveIncrement;
        private int pauseCount;
        private boolean background;
        private boolean unpaused;

        public void setBackground(boolean bl) {
            this.background = bl;
        }

        public void addCallbacks(List<Runnable> list) {
            this.callbacks.addAll(list);
        }

        public void setProvokesAoOs(boolean bl) {
            this.provokeAoOs = bl;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public Location getNextPosition() {
            return this.path.get(this.lastIndex - 1);
        }

        public Creature getCreature() {
            return this.creature;
        }

        public void incrementPauseCount() {
            ++this.pauseCount;
        }

        public void decrementPauseCount() {
            --this.pauseCount;
            if (this.pauseCount == 0) {
                this.lastTime = System.currentTimeMillis();
                this.unpaused = true;
            }
        }

        private Mover(Creature creature, Path path, boolean bl) {
            this.provokeAoOs = bl;
            this.callbacks = new ArrayList<Runnable>();
            this.creature = creature;
            this.path = path;
            this.initialPosition = creature.getLocation();
            this.lastTime = System.currentTimeMillis();
            this.lastIndex = path.length();
            this.combatRunner = Game.areaListener.getCombatRunner();
            this.finished = false;
            this.pauseCount = 0;
            this.currentMoveIncrement = Game.config.getCombatDelay();
            this.unpaused = false;
        }

        private void checkAoOsAndAnimate() {
            if (this.provokeAoOs && this.combatRunner.provokeAttacksOfOpportunity(this.creature, this)) {
                this.currentMoveIncrement = Game.config.getCombatDelay() * 5;
                return;
            }
            this.animateMovement(this.path.get(this.lastIndex - 1));
        }

        private void animateMovement(Location location) {
            Point point = this.creature.getLocation().getScreenPoint();
            Point point2 = location.getScreenPoint();
            EntityMovementAnimation entityMovementAnimation = new EntityMovementAnimation(this.creature, point2.x - point.x, point2.y - point.y, 0, 0);
            this.creature.setOffsetAnimation(entityMovementAnimation);
            Game.particleManager.addEntityOffsetAnimation(entityMovementAnimation);
        }

        private boolean isReadyForMovement(long l) {
            if (this.pauseCount == 0) {
                if (this.unpaused && l > this.lastTime + this.currentMoveIncrement - (long)Game.config.getCombatDelay()) {
                    this.unpaused = false;
                    if (this.lastIndex > 0) {
                        this.animateMovement(this.path.get(this.lastIndex - 1));
                    }
                }
                return l > this.lastTime + this.currentMoveIncrement;
            }
            return false;
        }

        private void performMovement(long l) {
            this.lastTime = l;
            --this.lastIndex;
            boolean bl = false;
            bl = !this.creature.timer.move(this.path.get(this.lastIndex)) ? true : this.creature.setLocation(this.path.get(this.lastIndex));
            if (this.creature.isPlayerFaction() && this.combatRunner.checkAIActivation()) {
                bl = true;
            }
            Game.mainViewer.updateInterface();
            if (this.creature.isPlayerFaction()) {
                this.creature.getLocation().getArea().getUtil().setPartyVisibility();
            }
            if (bl) {
                MovementHandler.this.interrupted = true;
            }
            this.currentMoveIncrement = Game.config.getCombatDelay();
            if (this.lastIndex == 0 || MovementHandler.this.interrupted) {
                this.moveBackToEmptyTile();
                if (!this.creature.isPlayerFaction()) {
                    this.currentMoveIncrement = Game.config.getCombatDelay() * 5;
                    if (this.creature.getEncounter() != null) {
                        this.creature.getEncounter().addHostiles(AreaUtil.getVisibleCreatures(this.creature, Faction.Relationship.Hostile));
                    }
                }
                if (!this.background && Game.config.autoScrollDuringCombat()) {
                    Game.areaViewer.addDelayedScrollToCreature(this.creature);
                }
            } else {
                this.checkAoOsAndAnimate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish() {
            this.creature.setCurrentlyMoving(false);
            for (Runnable runnable : this.callbacks) {
                runnable.run();
            }
            this.finished = true;
            Mover mover = this;
            synchronized (mover) {
                this.notifyAll();
            }
        }

        private void moveBackToEmptyTile() {
            int n;
            Path path = this.path.append(this.initialPosition.getX(), this.initialPosition.getY());
            Point point = this.creature.getLocation().getScreenPoint();
            int n2 = point.x + this.creature.getAnimatingOffsetX();
            int n3 = point.y + this.creature.getAnimatingOffsetY();
            for (int i = this.lastIndex; i < path.length(); ++i) {
                Location location = path.get(i);
                n = 0;
                for (Creature creature : location.getArea().getEntities().getCreatures(location.getX(), location.getY())) {
                    if (creature.isCurrentlyMoving() || this.creature == creature) continue;
                    n = 1;
                }
                if (n != 0) continue;
                if (location.equals(this.creature.getLocation())) break;
                this.creature.setLocation(location);
                break;
            }
            Point point2 = this.creature.getLocation().getScreenPoint();
            int n4 = n2 - point2.x;
            n = n3 - point2.y;
            EntityMovementAnimation entityMovementAnimation = new EntityMovementAnimation(this.creature, -n4, -n, n4, n);
            this.creature.setOffsetAnimation(entityMovementAnimation);
            Game.particleManager.addEntityOffsetAnimation(entityMovementAnimation);
            this.creature.setOffsetPoint(n4, n);
        }
    }

    public static enum Mode {
        Party,
        Single;

    }
}

