/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.interfacelock;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import net.sf.hale.Game;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Path;
import net.sf.hale.interfacelock.InterfaceLock;
import net.sf.hale.interfacelock.MovementHandler;

public class InterfaceLocker {
    private MovementHandler movementHandler;
    private boolean interfaceLocked = false;
    private final TreeSet<InterfaceLock> locks = new TreeSet();
    private final List<InterfaceLock> queuedLocks = new LinkedList<InterfaceLock>();
    private Iterator<InterfaceLock> iter = null;

    public InterfaceLocker() {
        this.movementHandler = new MovementHandler();
    }

    public MovementHandler.Mode getMovementMode() {
        return this.movementHandler.getMovementMode();
    }

    public void setMovementMode(MovementHandler.Mode mode) {
        this.movementHandler.setMovementMode(mode);
    }

    public void clear() {
        this.locks.clear();
        this.queuedLocks.clear();
        this.interfaceLocked = false;
        this.movementHandler.clear();
        this.movementHandler.setMovementMode(MovementHandler.Mode.Party);
    }

    public void interruptMovement() {
        this.movementHandler.interrupt();
    }

    public MovementHandler.Mover addMove(Creature creature, Path path, boolean bl) {
        this.interfaceLocked = true;
        return this.movementHandler.addMove(creature, path, bl);
    }

    public boolean hasActiveLock(InterfaceLock interfaceLock) {
        return this.locks.contains(interfaceLock);
    }

    public boolean locked() {
        return this.interfaceLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(InterfaceLock interfaceLock) {
        List<InterfaceLock> list = this.queuedLocks;
        synchronized (list) {
            this.queuedLocks.add(interfaceLock);
        }
        if (this.iter == null) {
            this.addQueued();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQueued() {
        if (this.queuedLocks.size() > 0) {
            List<InterfaceLock> list = this.queuedLocks;
            synchronized (list) {
                Iterator<InterfaceLock> iterator = this.queuedLocks.iterator();
                while (iterator.hasNext()) {
                    InterfaceLock interfaceLock = iterator.next();
                    this.locks.add(interfaceLock);
                    iterator.remove();
                }
            }
            this.interfaceLocked = true;
            Game.areaListener.computeMouseState();
            Game.mainViewer.updateInterface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTime(long l) {
        if (this.locks.size() > 0 && !this.movementHandler.isLocked()) {
            int n = this.locks.first().getPriority();
            for (InterfaceLock interfaceLock : this.locks) {
                if (interfaceLock.getPriority() != n) break;
                interfaceLock.setCurrentTime(l);
                if (!interfaceLock.checkFinished()) continue;
                InterfaceLock interfaceLock2 = interfaceLock;
                synchronized (interfaceLock2) {
                    interfaceLock.notifyAll();
                }
                this.iter.remove();
            }
        }
        this.addQueued();
        this.movementHandler.update(l);
        this.checkUnlockInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnlockInterface() {
        if (this.interfaceLocked && this.locks.size() == 0 && !this.movementHandler.isLocked()) {
            this.interfaceLocked = false;
            InterfaceLocker interfaceLocker = this;
            synchronized (interfaceLocker) {
                this.notifyAll();
            }
            Game.areaListener.computeMouseState();
            Game.mainViewer.updateInterface();
        }
    }
}

