/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.interfacelock;

import net.sf.hale.entity.Creature;

public class InterfaceLock
implements Comparable<InterfaceLock> {
    private long unlockTime;
    private Creature locker;
    private long curTime;
    private int priority;

    public InterfaceLock(Creature creature, long l) {
        this.unlockTime = l + System.currentTimeMillis();
        this.locker = creature;
        this.priority = 0;
    }

    public void setCurrentTime(long l) {
        this.curTime = l;
    }

    public void setUnlockTime(long l) {
        this.unlockTime = l;
    }

    protected boolean checkFinished() {
        return this.curTime >= this.unlockTime;
    }

    public final boolean isFinished() {
        return this.curTime >= this.unlockTime;
    }

    public Creature getLocker() {
        return this.locker;
    }

    public String toString() {
        return this.locker + " locked with unlock time: " + this.unlockTime;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(InterfaceLock interfaceLock) {
        if (this.getPriority() == interfaceLock.getPriority()) {
            return this.hashCode() - interfaceLock.hashCode();
        }
        return this.getPriority() - interfaceLock.getPriority();
    }
}

