/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.interfacelock;

import java.util.ArrayList;
import java.util.List;
import net.sf.hale.entity.Creature;
import net.sf.hale.interfacelock.InterfaceLock;

public class InterfaceCallbackLock
extends InterfaceLock {
    private int priority = 40;
    private final List<Runnable> callbacks = new ArrayList<Runnable>();

    public InterfaceCallbackLock(Creature creature, long l) {
        super(creature, l);
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public void addCallback(Runnable runnable) {
        this.callbacks.add(runnable);
    }

    public void addCallbacks(List<Runnable> list) {
        for (Runnable runnable : list) {
            this.callbacks.add(runnable);
        }
    }

    @Override
    protected boolean checkFinished() {
        if (super.checkFinished()) {
            this.runCallbacks();
            return true;
        }
        return false;
    }

    private void runCallbacks() {
        for (Runnable runnable : this.callbacks) {
            runnable.run();
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

