/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.interfacelock;

import net.sf.hale.Game;
import net.sf.hale.entity.Entity;
import net.sf.hale.interfacelock.EntityOffsetAnimation;

public class EntityMovementAnimation
extends EntityOffsetAnimation {
    private Entity mover;
    private int initialGridX;
    private int initialGridY;
    private float duration;
    private float elapsed;
    private float xPerSecond;
    private float yPerSecond;
    private int xOffset;
    private int yOffset;

    public EntityMovementAnimation(Entity entity, int n, int n2, int n3, int n4) {
        this.mover = entity;
        this.initialGridX = entity.getLocation().getX();
        this.initialGridY = entity.getLocation().getY();
        this.xOffset = n3;
        this.yOffset = n4;
        this.duration = (float)Game.config.getCombatDelay() / 1000.0f;
        this.elapsed = 0.0f;
        this.xPerSecond = (float)n / this.duration;
        this.yPerSecond = (float)n2 / this.duration;
        this.duration += 0.025f;
    }

    @Override
    protected boolean runAnimation(float f) {
        this.elapsed += f;
        if (this.elapsed > this.duration || (double)this.elapsed < 0.0 || this.initialGridX != this.mover.getLocation().getX() || this.initialGridY != this.mover.getLocation().getY()) {
            this.resetOffset();
            return true;
        }
        this.setOffset((float)this.xOffset + this.xPerSecond * this.elapsed, (float)this.yOffset + this.yPerSecond * this.elapsed);
        return false;
    }
}

