/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.interfacelock;

import net.sf.hale.Game;
import net.sf.hale.entity.Entity;
import net.sf.hale.interfacelock.EntityOffsetAnimation;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;

public class EntityAttackAnimation
extends EntityOffsetAnimation {
    private float halfDuration = (float)Game.config.getCombatDelay() / 1000.0f;
    private float elapsed = 0.0f;
    private float xPerSecond;
    private float yPerSecond;

    public EntityAttackAnimation(Entity entity, Entity entity2) {
        Point point = entity.getLocation().getScreenPoint();
        Point point2 = entity2.getLocation().getScreenPoint();
        double d = AreaUtil.euclideanDistance2(point.x, point.y, point2.x, point2.y);
        d = Math.sqrt(d);
        double d2 = 54.0 / d;
        this.xPerSecond = (float)d2 * (float)(point2.x - point.x) / this.halfDuration;
        this.yPerSecond = (float)d2 * (float)(point2.y - point.y) / this.halfDuration;
    }

    @Override
    protected boolean runAnimation(float f) {
        this.elapsed += f;
        if (this.elapsed > 2.0f * this.halfDuration) {
            this.resetOffset();
            return true;
        }
        if (this.elapsed > this.halfDuration) {
            float f2 = 2.0f * this.halfDuration - this.elapsed;
            this.setOffset(this.xPerSecond * f2, this.yPerSecond * f2);
            return false;
        }
        this.setOffset(this.xPerSecond * this.elapsed, this.yPerSecond * this.elapsed);
        return false;
    }
}

