/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.icon;

import de.matthiasmann.twl.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.icon.ComposedCreatureIcon;
import net.sf.hale.icon.IconRenderer;
import net.sf.hale.icon.SubIcon;
import net.sf.hale.rules.Race;
import net.sf.hale.rules.Ruleset;
import net.sf.hale.util.Point;
import org.lwjgl.opengl.GL11;

public class SubIconRenderer
implements IconRenderer {
    private final List<SubIcon> subIcons;
    private Color skinColor;
    private Color clothingColor;
    private SubIcon beard;
    private SubIcon hair;
    private SubIcon ears;

    public SubIconRenderer(ComposedCreatureIcon composedCreatureIcon, Race race, Ruleset.Gender gender) {
        this.subIcons = new ArrayList<SubIcon>();
        this.skinColor = composedCreatureIcon.getSkinColor();
        this.clothingColor = composedCreatureIcon.getClothingColor();
        if (!composedCreatureIcon.containsBaseBackgroundSubIcon()) {
            this.addBaseRacialSubIcons(race, gender);
        }
        for (ComposedCreatureIcon.Entry entry : composedCreatureIcon) {
            SubIcon.Factory factory = new SubIcon.Factory(entry.type, race, gender);
            factory.setPrimaryIcon(entry.spriteID, entry.color);
            this.add(factory.createSubIcon());
        }
        Collections.sort(this.subIcons);
    }

    protected SubIconRenderer(SubIconRenderer subIconRenderer) {
        this.subIcons = new ArrayList<SubIcon>(subIconRenderer.subIcons);
        this.beard = subIconRenderer.beard;
        this.hair = subIconRenderer.hair;
        this.ears = subIconRenderer.ears;
        this.skinColor = subIconRenderer.skinColor;
        this.clothingColor = subIconRenderer.clothingColor;
    }

    public void setSkinColor(Color color) {
        this.skinColor = color;
    }

    public void setClothingColor(Color color) {
        this.clothingColor = color;
    }

    public Color getSkinColor() {
        return this.skinColor;
    }

    public Color getClothingColor() {
        return this.clothingColor;
    }

    private void addBaseRacialSubIcons(Race race, Ruleset.Gender gender) {
        this.remove(SubIcon.Type.BaseBackground);
        this.remove(SubIcon.Type.BaseForeground);
        this.remove(SubIcon.Type.Ears);
        switch (gender) {
            case Male: {
                SubIcon.Factory factory;
                if (race.getMaleBackgroundIcon() != null) {
                    factory = new SubIcon.Factory(SubIcon.Type.BaseBackground, race, gender);
                    factory.setPrimaryIcon(race.getMaleBackgroundIcon(), this.getSkinColor());
                    factory.setSecondaryIcon(race.getMaleClothesIcon(), this.getClothingColor());
                    this.add(factory.createSubIcon());
                }
                if (race.getMaleForegroundIcon() != null) {
                    factory = new SubIcon.Factory(SubIcon.Type.BaseForeground, race, gender);
                    factory.setPrimaryIcon(race.getMaleForegroundIcon(), this.getSkinColor());
                    this.add(factory.createSubIcon());
                }
                if (race.getMaleEarsIcon() == null) break;
                factory = new SubIcon.Factory(SubIcon.Type.Ears, race, gender);
                factory.setPrimaryIcon(race.getMaleEarsIcon(), this.getSkinColor());
                this.add(factory.createSubIcon());
                break;
            }
            case Female: {
                SubIcon.Factory factory;
                if (race.getFemaleBackgroundIcon() != null) {
                    factory = new SubIcon.Factory(SubIcon.Type.BaseBackground, race, gender);
                    factory.setPrimaryIcon(race.getFemaleBackgroundIcon(), this.getSkinColor());
                    factory.setSecondaryIcon(race.getFemaleClothesIcon(), this.getClothingColor());
                    this.add(factory.createSubIcon());
                }
                if (race.getFemaleForegroundIcon() != null) {
                    factory = new SubIcon.Factory(SubIcon.Type.BaseForeground, race, gender);
                    factory.setPrimaryIcon(race.getFemaleForegroundIcon(), this.getSkinColor());
                    this.add(factory.createSubIcon());
                }
                if (race.getFemaleEarsIcon() == null) break;
                factory = new SubIcon.Factory(SubIcon.Type.Ears, race, gender);
                factory.setPrimaryIcon(race.getFemaleEarsIcon(), this.getSkinColor());
                this.add(factory.createSubIcon());
            }
        }
    }

    public synchronized void add(SubIcon subIcon) {
        if (subIcon == null) {
            return;
        }
        if (subIcon.getIcon() == null) {
            return;
        }
        this.remove(subIcon.getType());
        this.subIcons.add(subIcon);
        Collections.sort(this.subIcons);
        switch (subIcon.getType()) {
            case Ears: {
                this.ears = subIcon;
                break;
            }
            case Beard: {
                this.beard = subIcon;
                break;
            }
            case Hair: {
                this.hair = subIcon;
                break;
            }
            case Head: {
                this.remove(SubIcon.Type.Ears);
                break;
            }
        }
        if (subIcon.coversHair()) {
            this.remove(SubIcon.Type.Hair);
        }
        if (subIcon.coversBeard()) {
            this.remove(SubIcon.Type.Beard);
        }
    }

    public synchronized void clear() {
        this.subIcons.clear();
        this.hair = null;
        this.ears = null;
        this.beard = null;
    }

    public synchronized void remove(SubIcon.Type type) {
        boolean bl;
        Iterator<SubIcon> iterator = this.subIcons.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getType() != type) continue;
            iterator.remove();
        }
        if (type == SubIcon.Type.Head && this.ears != null) {
            this.add(this.ears);
        }
        if (type != SubIcon.Type.Beard) {
            bl = true;
            for (SubIcon subIcon : this.subIcons) {
                if (subIcon.coversBeard()) {
                    bl = false;
                    break;
                }
                if (subIcon.getType() != SubIcon.Type.Beard) continue;
                bl = false;
                break;
            }
            if (bl && this.beard != null) {
                this.add(this.beard);
            }
        }
        if (type != SubIcon.Type.Hair) {
            bl = true;
            for (SubIcon subIcon : this.subIcons) {
                if (subIcon.coversHair()) {
                    bl = false;
                    break;
                }
                if (subIcon.getType() != SubIcon.Type.Hair) continue;
                bl = false;
                break;
            }
            if (bl && this.hair != null) {
                this.add(this.hair);
            }
        }
    }

    public String getBeardIcon() {
        if (this.beard == null) {
            return null;
        }
        return this.beard.getIcon();
    }

    public Color getBeardColor() {
        if (this.beard == null) {
            return null;
        }
        return this.beard.getColor();
    }

    public String getHairIcon() {
        if (this.hair == null) {
            return null;
        }
        return this.hair.getIcon();
    }

    public Color getHairColor() {
        if (this.hair == null) {
            return null;
        }
        return this.hair.getColor();
    }

    public Point getOffset(String string) {
        return this.getOffset(SubIcon.Type.valueOf(string));
    }

    public Color getColor(String string) {
        return this.getColor(SubIcon.Type.valueOf(string));
    }

    public String getIcon(String string) {
        return this.getIcon(SubIcon.Type.valueOf(string));
    }

    public SubIcon getSubIcon(String string) {
        return this.getSubIcon(SubIcon.Type.valueOf(string));
    }

    public SubIcon getSubIcon(SubIcon.Type type) {
        for (SubIcon subIcon : this.subIcons) {
            if (subIcon.getType() != type) continue;
            return subIcon;
        }
        return null;
    }

    public Point getOffset(SubIcon.Type type) {
        for (SubIcon subIcon : this.subIcons) {
            if (subIcon.getType() != type) continue;
            return subIcon.getOffset();
        }
        return new Point(0, 0);
    }

    public Color getColor(SubIcon.Type type) {
        for (SubIcon subIcon : this.subIcons) {
            if (subIcon.getType() != type) continue;
            return subIcon.getColor();
        }
        return null;
    }

    public String getIcon(SubIcon.Type type) {
        for (SubIcon subIcon : this.subIcons) {
            if (subIcon.getType() != type) continue;
            return subIcon.getIcon();
        }
        return null;
    }

    @Override
    public synchronized void draw(int n, int n2) {
        for (SubIcon subIcon : this.subIcons) {
            subIcon.draw(n, n2);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawCentered(int n, int n2, int n3, int n4) {
        int n5 = n + (n3 - 72) / 2;
        int n6 = n2 + (n4 - 72) / 2;
        this.draw(n5, n6);
    }
}

