/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.icon;

import de.matthiasmann.twl.Color;
import net.sf.hale.resource.Sprite;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.rules.Race;
import net.sf.hale.rules.Ruleset;
import net.sf.hale.util.Point;
import org.lwjgl.opengl.GL11;

public class SubIcon
implements Comparable<SubIcon> {
    private Color color;
    private Color secondaryColor;
    private boolean coversHair;
    private boolean coversBeard;
    private String icon;
    private String secondaryIcon;
    private Type type;
    private Point offset;

    private SubIcon() {
    }

    public SubIcon multiplyByColor(Color color) {
        SubIcon subIcon = new SubIcon();
        subIcon.color = this.color.multiply(color);
        subIcon.secondaryColor = this.secondaryColor.multiply(color);
        subIcon.coversHair = this.coversHair;
        subIcon.coversBeard = this.coversBeard;
        subIcon.icon = this.icon;
        subIcon.secondaryIcon = this.secondaryIcon;
        subIcon.type = this.type;
        subIcon.offset = new Point(this.offset);
        return subIcon;
    }

    private void initialize(Race race, Ruleset.Gender gender) {
        String string;
        String string2;
        if (this.secondaryIcon == null) {
            string2 = this.icon + "Secondary";
            string = this.icon + race.getName() + (Object)((Object)gender) + "Secondary";
            String string3 = this.icon + race.getName() + "Secondary";
            if (SpriteManager.hasSprite(string)) {
                this.secondaryIcon = string;
            } else if (SpriteManager.hasSprite(string3)) {
                this.secondaryIcon = string3;
            } else if (SpriteManager.hasSprite(string2)) {
                this.secondaryIcon = string2;
            }
        }
        if (this.type == Type.OffHandWeapon) {
            string2 = this.icon + Type.OffHandWeapon.toString();
            if (SpriteManager.hasSprite(string2)) {
                this.icon = string2;
            }
        } else {
            string2 = this.icon + race.getName() + (Object)((Object)gender);
            string = this.icon + race.getName();
            if (SpriteManager.hasSprite(string2)) {
                this.icon = string2;
            } else if (SpriteManager.hasSprite(string)) {
                this.icon = string;
            }
        }
        if (this.color == null) {
            this.color = Color.WHITE;
        }
        if (this.secondaryColor == null) {
            this.secondaryColor = Color.WHITE;
        }
        this.offset = race.getIconOffset(this.type);
    }

    public boolean coversHair() {
        return this.coversHair;
    }

    public boolean coversBeard() {
        return this.coversBeard;
    }

    public int getWidth() {
        return SpriteManager.getSprite(this.icon).getWidth();
    }

    public int getHeight() {
        return SpriteManager.getSprite(this.icon).getHeight();
    }

    public final void draw(int n, int n2) {
        GL11.glColor4ub((byte)this.color.getR(), (byte)this.color.getG(), (byte)this.color.getB(), (byte)this.color.getA());
        SpriteManager.getSprite(this.icon).draw(n + this.offset.x, n2 + this.offset.y);
        Sprite sprite = SpriteManager.getSprite(this.secondaryIcon);
        if (sprite != null) {
            GL11.glColor4ub((byte)this.secondaryColor.getR(), (byte)this.secondaryColor.getG(), (byte)this.secondaryColor.getB(), (byte)this.secondaryColor.getA());
            sprite.draw(n + this.offset.x, n2 + this.offset.y);
        }
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public String getSecondaryIcon() {
        return this.secondaryIcon;
    }

    public Color getColor() {
        return this.color;
    }

    public Point getOffset() {
        return this.offset;
    }

    public String getIcon() {
        return this.icon;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int compareTo(SubIcon subIcon) {
        return this.type.compareTo(subIcon.type);
    }

    public static class Factory {
        private String icon;
        private Color color;
        private Type type;
        private Race race;
        private Ruleset.Gender gender;
        private boolean coversBeard;
        private boolean coversHair;
        private String secondaryIcon;
        private Color secondaryColor;

        public Factory(Type type, Race race, Ruleset.Gender gender) {
            this.type = type;
            this.race = race;
            this.gender = gender;
        }

        public void setCoversHair(boolean bl) {
            this.coversHair = bl;
        }

        public void setCoversBeard(boolean bl) {
            this.coversBeard = bl;
        }

        public void setPrimaryIcon(String string, Color color) {
            this.icon = string;
            this.color = color;
        }

        public void setSecondaryIcon(String string, Color color) {
            this.secondaryIcon = string;
            this.secondaryColor = color;
        }

        public SubIcon createSubIcon() {
            SubIcon subIcon = new SubIcon();
            subIcon.icon = this.icon;
            subIcon.color = this.color;
            subIcon.type = this.type;
            subIcon.coversBeard = this.coversBeard;
            subIcon.coversHair = this.coversHair;
            subIcon.secondaryIcon = this.secondaryIcon;
            subIcon.secondaryColor = this.secondaryColor;
            subIcon.initialize(this.race, this.gender);
            return subIcon;
        }
    }

    public static enum Type {
        Quiver,
        Cloak,
        BaseBackground,
        Boots,
        Torso,
        BaseForeground,
        Gloves,
        Hair,
        Ears,
        Head,
        Beard,
        Shield,
        MainHandWeapon,
        OffHandWeapon;

    }
}

