/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.icon;

import de.matthiasmann.twl.Color;
import net.sf.hale.icon.Icon;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.resource.Sprite;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.util.SimpleJSONObject;
import org.lwjgl.opengl.GL11;

public class SimpleIcon
implements Icon {
    private final String spriteResourceID;
    private final Color color;

    public SimpleIcon(SimpleJSONObject simpleJSONObject) {
        this.spriteResourceID = simpleJSONObject.get("sprite", null);
        this.color = simpleJSONObject.containsKey("color") ? Color.parserColor((String)simpleJSONObject.get("color", null)) : Color.WHITE;
    }

    protected SimpleIcon(String string) {
        this.spriteResourceID = string;
        this.color = Color.WHITE;
    }

    protected SimpleIcon(String string, Color color) {
        this.spriteResourceID = string;
        this.color = color;
    }

    public String getSpriteID() {
        return this.spriteResourceID;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public SimpleIcon multiplyByColor(Color color) {
        Color color2 = this.color.multiply(color);
        return new SimpleIcon(this.spriteResourceID, color2);
    }

    @Override
    public void draw(int n, int n2) {
        GL11.glColor4ub((byte)this.color.getR(), (byte)this.color.getG(), (byte)this.color.getB(), (byte)this.color.getA());
        SpriteManager.getSprite(this.spriteResourceID).draw(n, n2);
    }

    @Override
    public void drawCentered(int n, int n2, int n3, int n4) {
        Sprite sprite = SpriteManager.getSprite(this.spriteResourceID);
        GL11.glColor4ub((byte)this.color.getR(), (byte)this.color.getG(), (byte)this.color.getB(), (byte)this.color.getA());
        sprite.draw(n + (n3 - sprite.getWidth()) / 2, n2 + (n4 - sprite.getHeight()) / 2);
    }

    @Override
    public int getWidth() {
        return SpriteManager.getSprite(this.spriteResourceID).getWidth();
    }

    @Override
    public int getHeight() {
        return SpriteManager.getSprite(this.spriteResourceID).getHeight();
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("sprite", this.spriteResourceID);
        jSONOrderedObject.put("color", "#" + Integer.toHexString(this.color.toARGB()));
        return jSONOrderedObject;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleIcon)) {
            return false;
        }
        return ((SimpleIcon)object).spriteResourceID.equals(this.spriteResourceID);
    }

    public int hashCode() {
        return this.spriteResourceID.hashCode();
    }
}

