/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.icon;

import de.matthiasmann.twl.Color;
import net.sf.hale.icon.AnimatedIcon;
import net.sf.hale.icon.ComposedCreatureIcon;
import net.sf.hale.icon.ComposedIcon;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.SimpleIcon;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONObject;

public class IconFactory {
    public static Icon emptyIcon = new EmptyIcon();

    public static Icon createIcon(SimpleJSONObject simpleJSONObject) {
        if (simpleJSONObject.containsKey("frames")) {
            return new AnimatedIcon(simpleJSONObject);
        }
        if (simpleJSONObject.containsKey("subIcons")) {
            return new ComposedCreatureIcon(simpleJSONObject);
        }
        if (simpleJSONObject.containsKey("composed")) {
            return new ComposedIcon(simpleJSONObject);
        }
        return new SimpleIcon(simpleJSONObject);
    }

    public static Icon createIcon(String string) {
        return new SimpleIcon(string);
    }

    public static Icon createIcon(String string, Color color) {
        return new SimpleIcon(string, color);
    }

    private static class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        @Override
        public void drawCentered(int n, int n2, int n3, int n4) {
        }

        @Override
        public void draw(int n, int n2) {
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public JSONOrderedObject save() {
            return new JSONOrderedObject();
        }

        @Override
        public EmptyIcon multiplyByColor(Color color) {
            return this;
        }
    }
}

