/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.icon;

import de.matthiasmann.twl.Color;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class ComposedIcon
implements Icon {
    private int width;
    private int height;
    private List<Icon> icons;

    public ComposedIcon(SimpleJSONObject simpleJSONObject) {
        this.icons = new ArrayList<Icon>();
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("composed")) {
            this.icons.add(IconFactory.createIcon(simpleJSONArrayEntry.getObject()));
        }
        ((ArrayList)this.icons).trimToSize();
    }

    public ComposedIcon(Icon ... iconArray) {
        this.icons = new ArrayList<Icon>(iconArray.length);
        int n = 0;
        int n2 = 0;
        for (Icon icon : iconArray) {
            this.icons.add(icon);
            n = Math.max(n, icon.getWidth());
            n2 = Math.max(n2, icon.getHeight());
        }
        this.width = n;
        this.height = n2;
    }

    @Override
    public void draw(int n, int n2) {
        for (Icon icon : this.icons) {
            icon.draw(n, n2);
        }
    }

    @Override
    public void drawCentered(int n, int n2, int n3, int n4) {
        for (Icon icon : this.icons) {
            icon.drawCentered(n, n2, n3, n4);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Icon multiplyByColor(Color color) {
        Icon[] iconArray = new Icon[this.icons.size()];
        for (int i = 0; i < iconArray.length; ++i) {
            iconArray[i] = this.icons.get(i).multiplyByColor(color);
        }
        return new ComposedIcon(iconArray);
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject[] jSONOrderedObjectArray = new JSONOrderedObject[this.icons.size()];
        int n = 0;
        for (Icon icon : this.icons) {
            jSONOrderedObjectArray[n] = icon.save();
            ++n;
        }
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("composed", jSONOrderedObjectArray);
        return jSONOrderedObject;
    }
}

