/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.icon;

import de.matthiasmann.twl.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.SubIcon;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class ComposedCreatureIcon
implements Icon,
Iterable<Entry> {
    private final Color skinColor;
    private final Color clothingColor;
    private final List<Entry> entries;

    private ComposedCreatureIcon(Color color, Color color2) {
        this.entries = new ArrayList<Entry>();
        this.skinColor = color == null ? Color.WHITE : color;
        this.clothingColor = color2 == null ? Color.WHITE : color2;
    }

    public ComposedCreatureIcon(Color color, Color color2, List<SubIcon> list) {
        this(color, color2);
        for (SubIcon subIcon : list) {
            this.entries.add(new Entry(subIcon.getType(), subIcon.getIcon(), subIcon.getColor()));
        }
    }

    protected ComposedCreatureIcon(SimpleJSONObject simpleJSONObject) {
        this.entries = new ArrayList<Entry>();
        this.skinColor = simpleJSONObject.containsKey("skinColor") ? Color.parserColor((String)simpleJSONObject.get("skinColor", null)) : Color.WHITE;
        this.clothingColor = simpleJSONObject.containsKey("clothingColor") ? Color.parserColor((String)simpleJSONObject.get("clothingColor", null)) : Color.WHITE;
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("subIcons")) {
            SimpleJSONObject simpleJSONObject2 = simpleJSONArrayEntry.getObject();
            SubIcon.Type type = SubIcon.Type.valueOf(simpleJSONObject2.get("type", null));
            String string = simpleJSONObject2.get("sprite", null);
            Color color = Color.parserColor((String)simpleJSONObject2.get("color", null));
            this.entries.add(new Entry(type, string, color));
        }
    }

    protected ComposedCreatureIcon(ComposedCreatureIcon composedCreatureIcon) {
        this.entries = new ArrayList<Entry>(composedCreatureIcon.entries);
        this.skinColor = composedCreatureIcon.skinColor;
        this.clothingColor = composedCreatureIcon.clothingColor;
    }

    @Override
    public ComposedCreatureIcon multiplyByColor(Color color) {
        ComposedCreatureIcon composedCreatureIcon = new ComposedCreatureIcon(this.skinColor.multiply(color), this.clothingColor.multiply(color));
        for (Entry entry : this.entries) {
            composedCreatureIcon.entries.add(new Entry(entry.type, entry.spriteID, entry.color.multiply(color)));
        }
        return composedCreatureIcon;
    }

    public Color getSkinColor() {
        return this.skinColor;
    }

    public Color getClothingColor() {
        return this.clothingColor;
    }

    public boolean containsBaseBackgroundSubIcon() {
        for (Entry entry : this.entries) {
            if (entry.type != SubIcon.Type.BaseBackground) continue;
            return true;
        }
        return false;
    }

    @Override
    public void draw(int n, int n2) {
    }

    @Override
    public void drawCentered(int n, int n2, int n3, int n4) {
    }

    @Override
    public int getWidth() {
        return 72;
    }

    @Override
    public int getHeight() {
        return 72;
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("skinColor", "#" + Integer.toHexString(this.skinColor.toARGB()));
        jSONOrderedObject.put("clothingColor", "#" + Integer.toHexString(this.clothingColor.toARGB()));
        ArrayList<JSONOrderedObject> arrayList = new ArrayList<JSONOrderedObject>();
        for (Entry entry : this.entries) {
            JSONOrderedObject jSONOrderedObject2 = new JSONOrderedObject();
            jSONOrderedObject2.put("type", entry.type.name());
            jSONOrderedObject2.put("sprite", entry.spriteID);
            jSONOrderedObject2.put("color", "#" + Integer.toHexString(entry.color.toARGB()));
            arrayList.add(jSONOrderedObject2);
        }
        jSONOrderedObject.put("subIcons", arrayList.toArray());
        return jSONOrderedObject;
    }

    @Override
    public Iterator<Entry> iterator() {
        return new IconIterator();
    }

    private class IconIterator
    implements Iterator<Entry> {
        private int index = 0;

        private IconIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ComposedCreatureIcon.this.entries.size();
        }

        @Override
        public Entry next() {
            ++this.index;
            return (Entry)ComposedCreatureIcon.this.entries.get(this.index - 1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ComposedCreatureIcons are immutable and elements may not be removed");
        }
    }

    public class Entry {
        public final SubIcon.Type type;
        public final String spriteID;
        public final Color color;

        private Entry(SubIcon.Type type, String string, Color color) {
            this.type = type;
            this.spriteID = string;
            this.color = color;
        }
    }
}

