/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.icon;

import de.matthiasmann.twl.Color;
import net.sf.hale.Game;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.SimpleIcon;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class AnimatedIcon
implements Icon {
    private final int frameDuration;
    private final SimpleIcon[] frames;
    private final int totalDuration;

    public AnimatedIcon(SimpleJSONObject simpleJSONObject) {
        this.frameDuration = simpleJSONObject.get("frameDuration", 0);
        SimpleJSONArray simpleJSONArray = simpleJSONObject.getArray("frames");
        int n = 0;
        this.frames = new SimpleIcon[simpleJSONArray.size()];
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            SimpleIcon simpleIcon;
            this.frames[n] = simpleIcon = new SimpleIcon(simpleJSONArrayEntry.getObject());
            ++n;
        }
        this.totalDuration = this.frames.length * this.frameDuration;
    }

    private AnimatedIcon(int n, SimpleIcon[] simpleIconArray) {
        this.frameDuration = n;
        this.frames = simpleIconArray;
        this.totalDuration = n * simpleIconArray.length;
    }

    @Override
    public void draw(int n, int n2) {
        int n3 = (int)(Game.mainViewer.getFrameTime() % (long)this.totalDuration) / this.frameDuration;
        this.frames[n3].draw(n, n2);
    }

    @Override
    public void drawCentered(int n, int n2, int n3, int n4) {
        int n5 = (int)(Game.mainViewer.getFrameTime() % (long)this.totalDuration) / this.frameDuration;
        this.frames[n5].drawCentered(n, n2, n3, n4);
    }

    @Override
    public int getWidth() {
        return this.frames[0].getWidth();
    }

    @Override
    public int getHeight() {
        return this.frames[0].getHeight();
    }

    @Override
    public AnimatedIcon multiplyByColor(Color color) {
        SimpleIcon[] simpleIconArray = new SimpleIcon[this.frames.length];
        for (int i = 0; i < simpleIconArray.length; ++i) {
            simpleIconArray[i] = this.frames[i].multiplyByColor(color);
        }
        return new AnimatedIcon(this.frameDuration, simpleIconArray);
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("frameDuration", this.frameDuration);
        JSONOrderedObject[] jSONOrderedObjectArray = new JSONOrderedObject[this.frames.length];
        for (int i = 0; i < this.frames.length; ++i) {
            jSONOrderedObjectArray[i] = this.frames[i].save();
        }
        jSONOrderedObject.put("frames", jSONOrderedObjectArray);
        return jSONOrderedObject;
    }
}

