/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.Game;
import net.sf.hale.entity.Ammo;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.entity.Weapon;
import net.sf.hale.icon.SimpleIcon;
import net.sf.hale.rules.BaseWeapon;
import net.sf.hale.rules.DamageType;
import net.sf.hale.util.SimpleJSONObject;

public class WeaponTemplate
extends EquippableItemTemplate {
    private final Type type;
    private final Handed handed;
    private final BaseWeapon baseWeapon;
    private final SimpleIcon projectileIcon;
    private final boolean threatensAoOs;
    private final int minRange;
    private final int maxRange;
    private final DamageType damageType;
    private final int minDamage;
    private final int maxDamage;
    private final int criticalThreat;
    private final int criticalMultiplier;
    private final int attackCost;
    private final int rangePenalty;
    private final int maxStrengthBonus;
    private final int minStrengthBonus;

    public WeaponTemplate(String string, SimpleJSONObject simpleJSONObject) {
        super(string, simpleJSONObject);
        this.type = Type.valueOf(simpleJSONObject.get("weaponType", null));
        this.handed = Handed.valueOf(simpleJSONObject.get("handed", null));
        this.baseWeapon = Game.ruleset.getBaseWeapon(simpleJSONObject.get("baseWeapon", null));
        this.threatensAoOs = simpleJSONObject.get("threatensAoOs", false);
        this.minRange = simpleJSONObject.get("minRange", 0);
        this.maxRange = simpleJSONObject.get("maxRange", 0);
        this.damageType = Game.ruleset.getDamageType(simpleJSONObject.get("damageType", null));
        this.minDamage = simpleJSONObject.get("minDamage", 0);
        this.maxDamage = simpleJSONObject.get("maxDamage", 0);
        this.criticalThreat = simpleJSONObject.get("criticalThreat", 0);
        this.criticalMultiplier = simpleJSONObject.get("criticalMultiplier", 0);
        this.attackCost = simpleJSONObject.get("attackCost", 0);
        this.rangePenalty = simpleJSONObject.get("rangePenalty", 0);
        this.maxStrengthBonus = simpleJSONObject.get("maxStrengthBonus", 0);
        this.minStrengthBonus = simpleJSONObject.get("minStrengthBonus", -100);
        this.projectileIcon = simpleJSONObject.containsKey("projectileIcon") && this.type == Type.Thrown ? new SimpleIcon(simpleJSONObject.getObject("projectileIcon")) : null;
    }

    private WeaponTemplate(String string, WeaponTemplate weaponTemplate, CreatedItem createdItem) {
        super(string, weaponTemplate, createdItem);
        this.type = weaponTemplate.type;
        this.handed = weaponTemplate.handed;
        this.baseWeapon = weaponTemplate.baseWeapon;
        this.projectileIcon = weaponTemplate.projectileIcon;
        this.threatensAoOs = weaponTemplate.threatensAoOs;
        this.minRange = weaponTemplate.minRange;
        this.maxRange = weaponTemplate.maxRange;
        this.damageType = weaponTemplate.damageType;
        this.minDamage = weaponTemplate.minDamage;
        this.maxDamage = weaponTemplate.maxDamage;
        this.criticalThreat = weaponTemplate.criticalThreat;
        this.criticalMultiplier = weaponTemplate.criticalMultiplier;
        this.attackCost = weaponTemplate.attackCost;
        this.rangePenalty = weaponTemplate.rangePenalty;
        this.maxStrengthBonus = weaponTemplate.maxStrengthBonus;
        this.minStrengthBonus = weaponTemplate.minStrengthBonus;
    }

    @Override
    public WeaponTemplate createModifiedCopy(String string, CreatedItem createdItem) {
        return new WeaponTemplate(string, this, createdItem);
    }

    public SimpleIcon getProjectileIcon() {
        return this.projectileIcon;
    }

    @Override
    public Weapon createInstance() {
        return new Weapon(this);
    }

    public Type getWeaponType() {
        return this.type;
    }

    public Handed getHanded() {
        return this.handed;
    }

    public BaseWeapon getBaseWeapon() {
        return this.baseWeapon;
    }

    public boolean threatensAoOs() {
        return this.threatensAoOs;
    }

    public int getMinRange() {
        return this.minRange;
    }

    public int getMaxRange() {
        return this.maxRange;
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    public int getMinDamage() {
        return this.minDamage;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public int getCriticalThreat() {
        return this.criticalThreat;
    }

    public int getCriticalMultiplier() {
        return this.criticalMultiplier;
    }

    public int getAttackCost() {
        return this.attackCost;
    }

    public int getRangePenalty() {
        return this.rangePenalty;
    }

    public int getMaxStrengthBonus() {
        return this.maxStrengthBonus;
    }

    public int getMinStrengthBonus() {
        return this.minStrengthBonus;
    }

    @Override
    public boolean hasPrereqsToEquip(Creature creature) {
        return creature.stats.hasWeaponProficiency(this.baseWeapon.getName());
    }

    public boolean isAmmoForThisWeapon(Ammo ammo) {
        if (ammo == null) {
            return false;
        }
        return ammo.getTemplate().isUsableByBaseWeapon(this.baseWeapon);
    }

    public static enum Handed {
        Light("Light"),
        OneHanded("One Handed"),
        TwoHanded("Two Handed");

        public String name;

        private Handed(String string2) {
            this.name = string2;
        }
    }

    public static enum Type {
        Melee,
        Thrown,
        Ranged;

    }
}

