/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.area.Area;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.WeaponTemplate;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.util.SimpleJSONObject;

public class Weapon
extends EquippableItem {
    private final WeaponTemplate template;

    @Override
    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        super.load(simpleJSONObject, area, referenceHandler);
    }

    @Override
    public JSONOrderedObject save() {
        return super.save();
    }

    protected Weapon(WeaponTemplate weaponTemplate) {
        super(weaponTemplate);
        this.template = weaponTemplate;
    }

    @Override
    public WeaponTemplate getTemplate() {
        return this.template;
    }

    public boolean isTwoHanded() {
        return this.template.getHanded() == WeaponTemplate.Handed.TwoHanded;
    }

    public boolean isMelee() {
        return this.template.getWeaponType() == WeaponTemplate.Type.Melee;
    }

    public boolean isRanged() {
        return !this.isMelee();
    }

    public int getQualityAttackBonus() {
        if (this.getQuality() == null) {
            return 0;
        }
        return this.getQuality().getAttackBonus();
    }

    public int getQualityDamageBonus() {
        if (this.getQuality() == null) {
            return 0;
        }
        return this.getQuality().getDamageBonus();
    }
}

