/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.Game;
import net.sf.hale.entity.ItemTemplate;
import net.sf.hale.entity.Trap;
import net.sf.hale.rules.DamageType;
import net.sf.hale.util.SimpleJSONObject;

public class TrapTemplate
extends ItemTemplate {
    private final DamageType damageType;
    private final int minDamage;
    private final int maxDamage;
    private final int findDifficulty;
    private final int placeDifficulty;
    private final int disarmDifficulty;
    private final int recoverDifficulty;
    private final int reflexDifficulty;

    public TrapTemplate(String string, SimpleJSONObject simpleJSONObject) {
        super(string, simpleJSONObject);
        this.damageType = Game.ruleset.getDamageType(simpleJSONObject.get("damageType", null));
        this.minDamage = simpleJSONObject.get("minDamage", 0);
        this.maxDamage = simpleJSONObject.get("maxDamage", 0);
        this.findDifficulty = simpleJSONObject.get("findDifficulty", 0);
        this.placeDifficulty = simpleJSONObject.get("placeDifficulty", 0);
        this.disarmDifficulty = simpleJSONObject.get("disarmDifficulty", 0);
        this.recoverDifficulty = simpleJSONObject.get("recoverDifficulty", 0);
        this.reflexDifficulty = simpleJSONObject.get("reflexDifficulty", 0);
    }

    @Override
    public Trap createInstance() {
        return new Trap(this);
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    public int getMinDamage() {
        return this.minDamage;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public int getFindDifficulty() {
        return this.findDifficulty;
    }

    public int getPlaceDifficulty() {
        return this.placeDifficulty;
    }

    public int getDisarmDifficulty() {
        return this.disarmDifficulty;
    }

    public int getRecoverDifficulty() {
        return this.recoverDifficulty;
    }

    public int getReflexDifficulty() {
        return this.reflexDifficulty;
    }
}

