/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import de.matthiasmann.twl.Color;
import net.sf.hale.Game;
import net.sf.hale.ScriptInterface;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.area.Area;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.TrapTemplate;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.util.SimpleJSONObject;

public class Trap
extends Item {
    private boolean isSpotted;
    private final TrapTemplate template;

    @Override
    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        super.load(simpleJSONObject, area, referenceHandler);
        this.isSpotted = simpleJSONObject.get("isSpotted", false);
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("isSpotted", this.isSpotted);
        return jSONOrderedObject;
    }

    protected Trap(TrapTemplate trapTemplate) {
        super(trapTemplate);
        this.template = trapTemplate;
        this.isSpotted = false;
    }

    @Override
    public TrapTemplate getTemplate() {
        return this.template;
    }

    public boolean isSpotted() {
        return this.isSpotted;
    }

    public boolean canAttemptPlace(PC pC) {
        if (!pC.stats.has(Bonus.Type.TrapHandling)) {
            return false;
        }
        if (pC.getLocation().getTrap() != null) {
            Game.mainViewer.addFadeAway("Trap already present here", pC.getLocation().getX(), pC.getLocation().getY(), Color.RED);
            return false;
        }
        return true;
    }

    public boolean attemptPlace(PC pC) {
        if (!this.canAttemptPlace(pC)) {
            return false;
        }
        int n = this.modifyValueByQuality(this.template.getPlaceDifficulty());
        int n2 = pC.skills.getCheck("Traps", n);
        ScriptInterface.performSearchChecksForCreature(pC, Game.ruleset.getValue("HidePlaceTrapPenalty"));
        if (n2 >= n) {
            this.isSpotted = true;
            this.setLocation(pC.getLocation());
            this.setFaction(pC.getFaction());
            Game.curCampaign.curArea.placeTrap(this);
            pC.inventory.getUnequippedItems().remove(this);
            Game.mainViewer.addFadeAway("Trap placed", pC.getLocation().getX(), pC.getLocation().getY(), Color.RED);
            return true;
        }
        Game.mainViewer.addFadeAway("Failed to place trap", pC.getLocation().getX(), pC.getLocation().getY(), Color.RED);
        if (n2 < n - Game.ruleset.getValue("TrapCriticalFailureThreshold")) {
            this.fireTrap(pC);
        }
        return false;
    }

    public boolean attemptDisarm(Creature creature) {
        int n = this.modifyValueByQuality(this.template.getDisarmDifficulty());
        int n2 = creature.skills.getCheck("Traps", n);
        ScriptInterface.performSearchChecksForCreature(creature, Game.ruleset.getValue("HideDisarmTrapPenalty"));
        if (n2 >= n) {
            Game.curCampaign.curArea.removeEntity(this);
            return true;
        }
        if (n2 < n - Game.ruleset.getValue("TrapCriticalFailureThreshold")) {
            this.fireTrap(creature);
        }
        return false;
    }

    public boolean attemptRecover(Creature creature) {
        int n = this.modifyValueByQuality(this.template.getRecoverDifficulty());
        int n2 = creature.skills.getCheck("Traps", n);
        ScriptInterface.performSearchChecksForCreature(creature, Game.ruleset.getValue("HideRecoverTrapPenalty"));
        if (n2 >= n) {
            Game.curCampaign.curArea.removeEntity(this);
            creature.inventory.getUnequippedItems().add(this);
            return true;
        }
        if (n2 < n - Game.ruleset.getValue("TrapCriticalFailureThreshold")) {
            this.fireTrap(creature);
        }
        return false;
    }

    public boolean attemptSearch(Creature creature) {
        if (this.isSpotted) {
            return false;
        }
        int n = 10 * this.getLocation().getDistance(creature);
        if (creature.skills.performCheck("Search", this.modifyValueByQuality(this.template.getFindDifficulty()) + n)) {
            Game.mainViewer.addMessage("orange", creature.getTemplate().getName() + " spots a trap!");
            Game.mainViewer.addFadeAway("Search: Success", this.getLocation().getX(), this.getLocation().getY(), new Color(-5527127));
            this.isSpotted = true;
        }
        return this.isSpotted;
    }

    public boolean checkSpringTrap(Creature creature) {
        if (!this.getFaction().isHostile(creature)) {
            return false;
        }
        Game.mainViewer.addMessage("red", creature.getTemplate().getName() + " springs a trap.");
        this.fireTrap(creature);
        return true;
    }

    private void fireTrap(Creature creature) {
        Game.mainViewer.addFadeAway("Trap sprung", creature.getLocation().getX(), creature.getLocation().getY(), Color.RED);
        if (this.template.hasScript()) {
            this.template.getScript().executeFunction(ScriptFunctionType.onSpringTrap, this, creature);
        }
        ScriptInterface.performSearchChecksForCreature(creature, Game.ruleset.getValue("HideSpringTrapPenalty"));
        if (!creature.stats.getReflexResistanceCheck(this.modifyValueByQuality(this.template.getReflexDifficulty()))) {
            int n;
            int n2;
            int n3;
            if (this.template.hasScript()) {
                this.template.getScript().executeFunction(ScriptFunctionType.onTrapReflexFailed, this, creature);
            }
            if ((n3 = Game.dice.rand(n2 = this.modifyValueByQuality(this.template.getMinDamage()), n = this.modifyValueByQuality(this.template.getMaxDamage()))) != 0) {
                creature.takeDamage(n3, this.template.getDamageType().getName());
            }
        }
        Game.curCampaign.curArea.removeEntity(this);
    }

    public int modifyValueByQuality(int n) {
        int n2 = Game.ruleset.getValue("TrapQualityDifficultyNumerator");
        int n3 = Game.ruleset.getValue("TrapQualityDifficultyDenominator");
        int n4 = this.getQuality().getModifier();
        int n5 = n4 * n2 / n3;
        return n * (100 + n5) / 100;
    }
}

