/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.Path;

public class RoundTimer {
    private boolean isInFreeMode = false;
    private boolean active = false;
    private boolean waitedOnce = false;
    private int AP;
    private int maxAP;
    private final Creature parent;

    public RoundTimer(Creature creature) {
        this.parent = creature;
    }

    public void setFreeMode(boolean bl) {
        this.isInFreeMode = bl;
    }

    public boolean hasTakenAnAction() {
        return this.AP < this.maxAP;
    }

    public void reset() {
        this.active = true;
        this.AP = this.maxAP = Math.max(0, Game.ruleset.getValue("BaseActionPoints") + this.parent.stats.get(Bonus.Type.ActionPoint) * 100);
        this.parent.updateListeners();
    }

    private int getCost(Path path, int n) {
        int n2 = path.getMovementBonus(n);
        if (n2 < 0 && this.parent.stats.has(Bonus.Type.ImmobilizationImmunity)) {
            n2 = 0;
        }
        return this.parent.stats.get(Stat.MovementCost) * (100 - n2) / 100;
    }

    public int getLengthCurrentlyMovable(Path path) {
        if (!Game.isInTurnMode()) {
            return Integer.MAX_VALUE;
        }
        int n = 0;
        for (int i = 0; i < path.length(); ++i) {
            if ((n += this.getCost(path, i)) <= this.AP) continue;
            return i;
        }
        return path.length();
    }

    public int getMaxAP() {
        return this.maxAP;
    }

    public int getMovementCost(Path path) {
        int n = 0;
        for (int i = 0; i < path.length(); ++i) {
            n += this.getCost(path, i);
        }
        return n;
    }

    public boolean canMove(Path path) {
        if (!Game.isInTurnMode()) {
            return true;
        }
        if (this.parent.stats.isImmobilized()) {
            return false;
        }
        if (this.isInFreeMode) {
            return true;
        }
        return this.getMovementCost(path) <= this.AP;
    }

    public int getAP() {
        return this.AP;
    }

    public boolean canAttack() {
        return this.canPerformAction(this.parent.stats.get(Stat.AttackCost));
    }

    public boolean performAttack() {
        return this.performAction(this.parent.stats.get(Stat.AttackCost));
    }

    public boolean canPerformAction(String string) {
        return this.canPerformAction(Game.ruleset.getValue(string));
    }

    public boolean canPerformAction(int n) {
        if (this.parent.stats.isHelpless()) {
            return false;
        }
        return this.AP >= n || this.isInFreeMode;
    }

    public boolean performAction(String string) {
        return this.performAction(Game.ruleset.getValue(string));
    }

    public boolean performAction(int n) {
        if (!this.canPerformAction(n)) {
            return false;
        }
        if (Game.isInTurnMode() && !this.isInFreeMode) {
            this.AP -= n;
            this.parent.updateListeners();
        }
        return true;
    }

    public boolean canActivateAbility(String string) {
        Ability ability = Game.ruleset.getAbility(string);
        return this.canPerformAction(ability.getAPCost());
    }

    private int getCostToEquipItem(EquippableItem equippableItem) {
        switch (equippableItem.getTemplate().getType()) {
            case Weapon: 
            case Shield: {
                return Game.ruleset.getValue("EquipItemCost") * (100 - this.parent.stats.get(Bonus.Type.ActionPointEquipHands)) / 100;
            }
            case Armor: {
                return Game.ruleset.getValue("EquipArmorCost");
            }
        }
        return Game.ruleset.getValue("EquipItemCost");
    }

    public boolean canPerformEquipAction(EquippableItem equippableItem) {
        return this.canPerformAction(this.getCostToEquipItem(equippableItem));
    }

    public boolean performEquipAction(EquippableItem equippableItem) {
        return this.performAction(this.getCostToEquipItem(equippableItem));
    }

    public int getMovementLeft() {
        int n = this.parent.stats.get(Stat.MovementCost);
        int n2 = n / 100;
        return 5 * this.AP / n2;
    }

    public boolean move(Location location) {
        return this.move(new Path(location));
    }

    public boolean move(Path path) {
        if (!this.canMove(path)) {
            return false;
        }
        if (Game.isInTurnMode() && !this.isInFreeMode) {
            this.AP -= this.getMovementCost(path);
            this.parent.updateListeners();
        }
        return true;
    }

    public void endTurn() {
        this.active = false;
        this.AP = 0;
        this.waitedOnce = false;
        this.parent.updateListeners();
    }

    public void waitTurn() {
        this.active = false;
        this.AP = 0;
        this.waitedOnce = true;
        this.parent.updateListeners();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isWaitedOnce() {
        return this.waitedOnce;
    }
}

