/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.Iterator;
import java.util.List;
import net.sf.hale.area.Area;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.util.Point;

public class Path
implements Iterable<Location> {
    private final Area area;
    private final int[] xCoords;
    private final int[] yCoords;
    private final Creature[] aoOs;

    public Path(Area area) {
        this.area = area;
        this.xCoords = new int[0];
        this.yCoords = new int[0];
        this.aoOs = new Creature[0];
    }

    public Path(Location location) {
        this.area = location.getArea();
        this.xCoords = new int[1];
        this.yCoords = new int[1];
        this.xCoords[0] = location.getX();
        this.yCoords[0] = location.getY();
        this.aoOs = new Creature[0];
    }

    public Path(Area area, List<Point> list, List<Creature> list2) {
        int n;
        this.area = area;
        this.xCoords = new int[list.size()];
        this.yCoords = new int[list.size()];
        for (n = 0; n < list.size(); ++n) {
            this.xCoords[n] = list.get((int)n).x;
            this.yCoords[n] = list.get((int)n).y;
        }
        this.aoOs = new Creature[list2.size()];
        for (n = 0; n < list2.size(); ++n) {
            this.aoOs[n] = list2.get(n);
        }
    }

    private Path(Area area, int[] nArray, int[] nArray2) {
        this.area = area;
        this.xCoords = nArray;
        this.yCoords = nArray2;
        this.aoOs = new Creature[0];
    }

    public Creature getAoOAttacker(int n) {
        return this.aoOs[n];
    }

    public int getNumAoOs() {
        return this.aoOs.length;
    }

    public int length() {
        return this.xCoords.length;
    }

    public Location get(int n) {
        return new Location(this.area, this.xCoords[n], this.yCoords[n]);
    }

    public int getMovementBonus(int n) {
        return this.area.getMovementBonus(this.xCoords[n], this.yCoords[n]);
    }

    public Path truncate(int n) {
        if (this.xCoords.length <= n) {
            return this;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = this.xCoords.length - n;
        for (int i = this.xCoords.length - 1; i >= n2; --i) {
            nArray[i - n2] = this.xCoords[i];
            nArray2[i - n2] = this.yCoords[i];
        }
        return new Path(this.area, nArray, nArray2);
    }

    public Path append(int n, int n2) {
        int[] nArray = new int[this.length() + 1];
        int[] nArray2 = new int[this.length() + 1];
        for (int i = 0; i < this.length(); ++i) {
            nArray[i] = this.xCoords[i];
            nArray2[i] = this.yCoords[i];
        }
        nArray[this.length()] = n;
        nArray2[this.length()] = n2;
        return new Path(this.area, nArray, nArray2);
    }

    @Override
    public Iterator<Location> iterator() {
        return new PathIterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.area.getID());
        stringBuilder.append(" : { ");
        for (int i = this.xCoords.length - 1; i >= 0; --i) {
            stringBuilder.append("[");
            stringBuilder.append(this.xCoords[i]);
            stringBuilder.append(", ");
            stringBuilder.append(this.yCoords[i]);
            stringBuilder.append("]");
            if (i == 0) {
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private class PathIterator
    implements Iterator<Location> {
        private int index = 0;

        private PathIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Path.this.xCoords.length;
        }

        @Override
        public Location next() {
            ++this.index;
            return Path.this.get(this.index - 1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Paths are immutable.");
        }
    }
}

