/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.Game;
import net.sf.hale.area.Area;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.PCTemplate;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.quickbar.Quickbar;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public final class PC
extends Creature {
    private final PCTemplate template;
    private int experiencePoints;
    private int unspentSkillPoints;
    public final Quickbar quickbar;

    @Override
    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        SimpleJSONObject simpleJSONObject2 = simpleJSONObject.getObject("attributes");
        int[] nArray = new int[]{simpleJSONObject2.get("strength", 0), simpleJSONObject2.get("dexterity", 0), simpleJSONObject2.get("constitution", 0), simpleJSONObject2.get("intelligence", 0), simpleJSONObject2.get("wisdom", 0), simpleJSONObject2.get("charisma", 0)};
        this.stats.setAttributes(nArray);
        super.load(simpleJSONObject, area, referenceHandler);
        this.experiencePoints = simpleJSONObject.get("experiencePoints", 0);
        this.unspentSkillPoints = simpleJSONObject.get("unspentSkillPoints", 0);
        this.quickbar.load(simpleJSONObject.getObject("quickbar"));
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("name", this.template.getName());
        jSONOrderedObject.put("gender", this.template.getGender().name());
        jSONOrderedObject.put("race", this.template.getRace().getID());
        jSONOrderedObject.put("portrait", this.template.getPortrait());
        jSONOrderedObject.put("icon", this.template.getIcon().save());
        JSONOrderedObject jSONOrderedObject2 = new JSONOrderedObject();
        jSONOrderedObject2.put("strength", this.stats.get(Stat.BaseStr));
        jSONOrderedObject2.put("dexterity", this.stats.get(Stat.BaseDex));
        jSONOrderedObject2.put("constitution", this.stats.get(Stat.BaseCon));
        jSONOrderedObject2.put("intelligence", this.stats.get(Stat.BaseInt));
        jSONOrderedObject2.put("wisdom", this.stats.get(Stat.BaseWis));
        jSONOrderedObject2.put("charisma", this.stats.get(Stat.BaseCha));
        jSONOrderedObject.put("attributes", jSONOrderedObject2);
        jSONOrderedObject.put("experiencePoints", this.experiencePoints);
        jSONOrderedObject.put("unspentSkillPoints", this.unspentSkillPoints);
        jSONOrderedObject.put("quickbar", this.quickbar.save());
        return jSONOrderedObject;
    }

    public PC(PCTemplate pCTemplate, SimpleJSONParser simpleJSONParser) {
        super(pCTemplate, simpleJSONParser);
        this.template = pCTemplate;
        this.quickbar = new Quickbar(this);
        if (simpleJSONParser.containsKey("quickbar")) {
            this.quickbar.load(simpleJSONParser.getObject("quickbar"));
        }
        if (simpleJSONParser.containsKey("experiencePoints")) {
            this.experiencePoints = simpleJSONParser.get("experiencePoints", 0);
        }
        if (simpleJSONParser.containsKey("unspentSkillPoints")) {
            this.unspentSkillPoints = simpleJSONParser.get("unspentSkillPoints", 0);
        }
    }

    public PC(PCTemplate pCTemplate) {
        super(pCTemplate);
        this.template = pCTemplate;
        this.quickbar = new Quickbar(this);
        this.experiencePoints = 0;
        this.unspentSkillPoints = 0;
    }

    public PC(PC pC) {
        super(pC);
        this.template = pC.template;
        this.quickbar = new Quickbar(pC.quickbar, this);
        this.experiencePoints = pC.experiencePoints;
        this.unspentSkillPoints = pC.unspentSkillPoints;
    }

    @Override
    public PCTemplate getTemplate() {
        return this.template;
    }

    public int getExperiencePoints() {
        return this.experiencePoints;
    }

    public void addExperiencePoints(int n) {
        this.experiencePoints += n;
    }

    public int getUnspentSkillPoints() {
        return this.unspentSkillPoints;
    }

    public void setUnspentSkillPoints(int n) {
        this.unspentSkillPoints = n;
    }

    @Override
    public boolean elapseTime(int n) {
        boolean bl = super.elapseTime(n);
        if (Game.isInTurnMode()) {
            if (this.isDying()) {
                this.takeDamage(n, "Effect");
                Game.mainViewer.addMessage("red", this.getTemplate().getName() + " is dying with " + this.getCurrentHitPoints() + " HP.");
            }
        } else if (!this.isDead() && this.getCurrentHitPoints() < this.stats.get(Stat.MaxHP)) {
            this.healDamage(n * (1 + this.stats.get(Stat.MaxHP) / Game.ruleset.getValue("OutsideCombatHealingFactor")));
        }
        return bl;
    }
}

