/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.entity.EntityTemplate;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.util.SimpleJSONObject;

public abstract class OpenableTemplate
extends EntityTemplate {
    private final Icon openIcon;
    private final Icon closedIcon;
    private final boolean isDefaultLocked;
    private final int lockDifficulty;
    private final String keyID;
    private final boolean isKeyRequiredToUnlock;
    private final boolean isRemoveKeyOnUnlock;

    public OpenableTemplate(String string, SimpleJSONObject simpleJSONObject) {
        super(string, simpleJSONObject);
        this.openIcon = simpleJSONObject.containsKey("openIcon") ? IconFactory.createIcon(simpleJSONObject.getObject("openIcon")) : IconFactory.emptyIcon;
        this.closedIcon = simpleJSONObject.containsKey("closedIcon") ? IconFactory.createIcon(simpleJSONObject.getObject("closedIcon")) : IconFactory.emptyIcon;
        this.isDefaultLocked = simpleJSONObject.get("isLocked", false);
        this.lockDifficulty = simpleJSONObject.get("lockDifficulty", 0);
        this.keyID = simpleJSONObject.get("keyID", null);
        this.isKeyRequiredToUnlock = simpleJSONObject.get("keyRequired", false);
        this.isRemoveKeyOnUnlock = simpleJSONObject.get("removeKeyOnUnlock", false);
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public boolean isDefaultLocked() {
        return this.isDefaultLocked;
    }

    public int getLockDifficulty() {
        return this.lockDifficulty;
    }

    public boolean hasKey() {
        return this.keyID != null;
    }

    public String getKeyID() {
        return this.keyID;
    }

    public boolean isKeyRequiredToUnlock() {
        return this.isKeyRequiredToUnlock;
    }

    public boolean isRemoveKeyOnUnlock() {
        return this.isRemoveKeyOnUnlock;
    }
}

