/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.Game;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.area.Area;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.OpenableTemplate;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.util.SimpleJSONObject;

public abstract class Openable
extends Entity {
    private OpenableTemplate template;
    private boolean isOpen;
    private boolean isLocked;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("isOpen", this.isOpen);
        if (this.isLocked) {
            jSONOrderedObject.put("isLocked", this.isLocked);
        }
        return jSONOrderedObject;
    }

    @Override
    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        super.load(simpleJSONObject, area, referenceHandler);
        this.isOpen = simpleJSONObject.get("isOpen", false);
        this.isLocked = simpleJSONObject.containsKey("isLocked") ? simpleJSONObject.get("isLocked", false) : false;
    }

    protected Openable(OpenableTemplate openableTemplate) {
        super(openableTemplate);
        this.template = openableTemplate;
        this.isOpen = false;
        this.isLocked = openableTemplate.isDefaultLocked();
    }

    @Override
    public OpenableTemplate getTemplate() {
        return this.template;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean bl) {
        this.isLocked = bl;
    }

    public void unlock() {
        this.isLocked = false;
    }

    public void unlock(Creature creature) {
        if (this.isLocked && this.template.hasScript()) {
            this.template.getScript().executeFunction(ScriptFunctionType.onUnlock, this, creature);
        }
        this.isLocked = false;
    }

    public boolean attemptUnlock(Creature creature) {
        if (!this.isLocked) {
            return true;
        }
        if (this.template.isKeyRequiredToUnlock()) {
            Game.mainViewer.addMessage("orange", "A specific key is required to unlock that object.");
        } else {
            int n = this.template.getLockDifficulty();
            int n2 = creature.skills.getCheck("Locks", n);
            if (n2 >= n) {
                this.unlock(creature);
            }
        }
        return !this.isLocked;
    }

    public boolean attemptOpen(Creature creature) {
        if (this.isLocked && this.template.hasKey() && creature.inventory.getTotalQuantity(this.template.getKeyID()) > 0) {
            Game.mainViewer.addMessage("orange", creature.getTemplate().getName() + " uses a key.");
            this.unlock(creature);
            if (this.template.isRemoveKeyOnUnlock()) {
                creature.inventory.remove(this.template.getKeyID(), 1);
            }
        }
        if (!this.isLocked) {
            if (!this.isOpen && this.template.hasScript()) {
                this.template.getScript().executeFunction(ScriptFunctionType.onOpen, this, creature);
            }
            this.isOpen = true;
        } else {
            Game.mainViewer.addMessage("orange", "That object is locked.");
        }
        return this.isOpen;
    }

    public void close(Creature creature) {
        if (this.isOpen && this.template.hasScript()) {
            this.template.getScript().executeFunction(ScriptFunctionType.onClose, this, creature);
        }
        this.isOpen = false;
    }

    @Override
    public void areaDraw(int n, int n2) {
        if (this.isOpen) {
            this.template.getOpenIcon().drawCentered(n, n2, 72, 72);
        } else {
            this.template.getClosedIcon().drawCentered(n, n2, 72, 72);
        }
    }
}

