/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.Iterator;
import net.sf.hale.Game;
import net.sf.hale.entity.CreatureTemplate;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.LootList;
import net.sf.hale.entity.NPC;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class NPCTemplate
extends CreatureTemplate {
    private int minReward;
    private int maxReward;
    private LootList loot;
    private boolean isImmortal;

    public NPCTemplate(String string, SimpleJSONObject simpleJSONObject) {
        super(string, simpleJSONObject);
        this.isImmortal = simpleJSONObject.containsKey("isImmortal") ? simpleJSONObject.get("isImmortal", false) : false;
        if (simpleJSONObject.containsKey("reward")) {
            int n;
            SimpleJSONArray simpleJSONArray = simpleJSONObject.getArray("reward");
            Iterator<SimpleJSONArrayEntry> iterator = simpleJSONArray.iterator();
            int n2 = iterator.next().getInt(0);
            if (n2 < (n = iterator.next().getInt(0))) {
                this.minReward = n2;
                this.maxReward = n;
            } else {
                this.minReward = n;
                this.maxReward = n2;
            }
        }
        this.loot = simpleJSONObject.containsKey("loot") ? new LootList(simpleJSONObject.getArray("loot")) : null;
    }

    @Override
    public NPC createInstance() {
        throw new IllegalStateException("Instances of NPCs cannot be created directly");
    }

    public int generateReward() {
        if (this.minReward == this.maxReward) {
            return this.minReward;
        }
        return Game.dice.rand(this.minReward, this.maxReward);
    }

    public ItemList generateLoot() {
        if (this.loot == null) {
            return new ItemList();
        }
        return this.loot.generate();
    }

    public boolean isImmortal() {
        return this.isImmortal;
    }
}

