/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.ItemTemplate;
import net.sf.hale.entity.SavedItemList;
import net.sf.hale.rules.Quality;
import net.sf.hale.rules.Recipe;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class LootList {
    private final List<Entry> entries = new ArrayList<Entry>();

    public LootList(SimpleJSONArray simpleJSONArray) {
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            String string = simpleJSONObject.get("id", null);
            SimpleJSONObject simpleJSONObject2 = simpleJSONObject.getObject("probability");
            int n = simpleJSONObject2.get("value", 0);
            ProbabilityMode probabilityMode = ProbabilityMode.valueOf(simpleJSONObject2.get("mode", null));
            this.entries.add(new Entry(string, n, probabilityMode));
        }
    }

    public ItemList generate() {
        ItemList itemList = new ItemList();
        for (Entry entry : this.entries) {
            SavedItemList savedItemList = Game.ruleset.getItemList(entry.itemListID);
            if (savedItemList == null) {
                Logger.appendToErrorLog("Attempting to generate loot list but item list " + entry.itemListID + " does not exist.");
                continue;
            }
            if (savedItemList.size() == 0) continue;
            switch (entry.mode) {
                case PerList: {
                    if (Game.dice.rand(1, 100) > entry.probability) break;
                    this.addRandomQuantityEntry(savedItemList.getRandomEntry(), itemList, savedItemList.getEnchantmentChance(), savedItemList.getEnchantmentSkillModifier());
                    break;
                }
                case PerItem: {
                    for (ItemList.Entry entry2 : savedItemList) {
                        if (Game.dice.rand(1, 100) > entry.probability) continue;
                        this.addRandomQuantityEntry(entry2, itemList, savedItemList.getEnchantmentChance(), savedItemList.getEnchantmentSkillModifier());
                    }
                    break;
                }
            }
        }
        return itemList;
    }

    private void addRandomQuantityEntry(ItemList.Entry entry, ItemList itemList, int n, int n2) {
        int n3 = entry.getQuantity() == Integer.MAX_VALUE ? Integer.MAX_VALUE : Game.dice.rand(1, entry.getQuantity());
        String string = entry.getID();
        Quality quality = entry.getQuality();
        List<String> list = this.getUsableRecipes(entry, n);
        if (list.size() > 0) {
            int n4 = list.size() == 1 ? 0 : Game.dice.rand(0, list.size() - 1);
            Recipe recipe = Game.curCampaign.getRecipe(list.get(n4));
            EquippableItem equippableItem = recipe.createItem(entry.getID(), entry.getQuality(), n2);
            string = ((Item)equippableItem).getTemplate().getID();
            quality = equippableItem.getQuality();
        }
        itemList.add(string, quality, n3);
    }

    private List<String> getUsableRecipes(ItemList.Entry entry, int n) {
        ItemTemplate itemTemplate = EntityManager.getItemTemplate(entry.getID());
        if (!(itemTemplate instanceof EquippableItemTemplate)) {
            return Collections.emptyList();
        }
        EquippableItemTemplate equippableItemTemplate = (EquippableItemTemplate)itemTemplate;
        if (equippableItemTemplate.getEnchantments().size() > 0) {
            return Collections.emptyList();
        }
        if (Game.dice.rand(1, 100) <= n) {
            return Game.curCampaign.getEnchantmentsForItemType(equippableItemTemplate.getType());
        }
        return Collections.emptyList();
    }

    private class Entry {
        private final String itemListID;
        private final int probability;
        private final ProbabilityMode mode;

        private Entry(String string, int n, ProbabilityMode probabilityMode) {
            this.itemListID = string;
            this.probability = n;
            this.mode = probabilityMode;
        }
    }

    private static enum ProbabilityMode {
        PerItem,
        PerList;

    }
}

