/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.Collection;
import java.util.List;
import net.sf.hale.ability.Effect;
import net.sf.hale.area.Area;
import net.sf.hale.area.Transition;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Door;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.Openable;
import net.sf.hale.entity.Trap;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import net.sf.hale.util.PointImmutable;
import net.sf.hale.util.SimpleJSONObject;

public class Location
implements Saveable {
    private final Area area;
    private final int x;
    private final int y;
    public static final Location Inventory = new Location();

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("x", this.x);
        jSONOrderedObject.put("y", this.y);
        return jSONOrderedObject;
    }

    public static Location load(SimpleJSONObject simpleJSONObject, Area area) {
        int n = simpleJSONObject.get("x", 0);
        int n2 = simpleJSONObject.get("y", 0);
        return new Location(area, n, n2);
    }

    private Location() {
        this.area = null;
        this.x = 0;
        this.y = 0;
    }

    public Location(Area area, int n, int n2) {
        this.area = area;
        this.x = n;
        this.y = n2;
    }

    public Location(Area area, Point point) {
        this.area = area;
        this.x = point.x;
        this.y = point.y;
    }

    public Location(Area area, PointImmutable pointImmutable) {
        this.area = area;
        this.x = pointImmutable.x;
        this.y = pointImmutable.y;
    }

    public Area getArea() {
        return this.area;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getScreenPoint() {
        return AreaUtil.convertGridToScreen(this.x, this.y);
    }

    public Point getCenteredScreenPoint() {
        return AreaUtil.convertGridToScreenAndCenter(this.x, this.y);
    }

    public Point toPoint() {
        return new Point(this.x, this.y);
    }

    public double getScreenDistance(Location location) {
        if (this.area != location.getArea()) {
            return 2.147483647E9;
        }
        Point point = AreaUtil.convertGridToScreen(this.x, this.y);
        Point point2 = AreaUtil.convertGridToScreen(location.x, location.y);
        int n = AreaUtil.euclideanDistance2(point.x, point.y, point2.x, point2.y);
        return Math.sqrt(n);
    }

    public double getScreenDistance(Point point) {
        Point point2 = AreaUtil.convertGridToScreen(this.x, this.y);
        Point point3 = AreaUtil.convertGridToScreen(point.x, point.y);
        int n = AreaUtil.euclideanDistance2(point2.x, point2.y, point3.x, point3.y);
        return Math.sqrt(n);
    }

    public double getScreenDistance(int n, int n2) {
        Point point = AreaUtil.convertGridToScreen(n, n2);
        Point point2 = AreaUtil.convertGridToScreen(n, n2);
        int n3 = AreaUtil.euclideanDistance2(point.x, point.y, point2.x, point2.y);
        return Math.sqrt(n3);
    }

    public int getDistance(Point point) {
        return AreaUtil.distance(this.x, this.y, point.x, point.y);
    }

    public int getDistance(int n, int n2) {
        return AreaUtil.distance(this.x, this.y, n, n2);
    }

    public int getDistance(Location location) {
        if (this.area != location.getArea()) {
            return Integer.MAX_VALUE;
        }
        return AreaUtil.distance(this.x, this.y, location.x, location.y);
    }

    public int getDistance(Entity entity) {
        return this.getDistance(entity.getLocation());
    }

    public Collection<Entity> getEntities() {
        if (this.area == null) {
            throw new UnsupportedOperationException("getEntities() may only be called on locations within an Area");
        }
        return this.area.getEntities().getEntitiesSet(this.x, this.y);
    }

    public Creature getCreature() {
        if (this.area == null) {
            throw new UnsupportedOperationException("getCreature() may only be called on locations within an Area");
        }
        return this.area.getCreatureAtGridPoint(this.x, this.y);
    }

    public Trap getTrap() {
        if (this.area == null) {
            throw new UnsupportedOperationException("getTrap() may only be called on locations within an Area");
        }
        return this.area.getTrapAtGridPoint(this.x, this.y);
    }

    public Container getContainer() {
        if (this.area == null) {
            throw new UnsupportedOperationException("getContainer() may only be called on locations within an Area");
        }
        return this.area.getContainerAtGridPoint(this.x, this.y);
    }

    public Openable getOpenable() {
        if (this.area == null) {
            throw new UnsupportedOperationException("getOpenable() may only be called on locations within an Area");
        }
        return this.area.getOpenableAtGridPoint(this.x, this.y);
    }

    public Door getDoor() {
        if (this.area == null) {
            throw new UnsupportedOperationException("getDoor() may only be called on locations within an Area");
        }
        return this.area.getDoorAtGridPoint(this.x, this.y);
    }

    public Transition getAreaTransition() {
        if (this.area == null) {
            throw new UnsupportedOperationException("getDoor() may only be called on locations within an Area");
        }
        return this.area.getTransitionAtGridPoint(this.x, this.y);
    }

    public boolean isInAreaBounds() {
        if (this.area == null) {
            return false;
        }
        return this.x >= 0 && this.x < this.area.getWidth() && this.y >= 0 && this.y < this.area.getHeight();
    }

    public byte getElevation() {
        if (this.area == null) {
            throw new UnsupportedOperationException("getElevation() can only be called on locations within an Area");
        }
        return this.area.getElevationGrid().getElevation(this.x, this.y);
    }

    public List<Effect> getEffects() {
        if (this.area == null) {
            throw new UnsupportedOperationException("getEffects() may only be called on locations within an Area");
        }
        return this.area.getEffectsAt(this.x, this.y);
    }

    public boolean isPassable() {
        if (this.area == null) {
            throw new UnsupportedOperationException("isAreaPassable() can only be called on locations within an Area");
        }
        return this.area.isPassable(this.x, this.y);
    }

    public boolean isExplored() {
        if (this.area == null) {
            throw new UnsupportedOperationException("isAreaExplored() can only be called on locations within an Area");
        }
        return this.area.getExplored()[this.x][this.y];
    }

    public boolean equals(Object object) {
        if (!(object instanceof Location)) {
            return false;
        }
        Location location = (Location)object;
        return location.area == this.area && location.x == this.x && location.y == this.y;
    }

    public Location getInSameArea(int n, int n2) {
        return new Location(this.area, n, n2);
    }

    public String toString() {
        if (this.area != null) {
            return "(" + this.x + ", " + this.y + " in " + this.area.getName() + ")";
        }
        return "(" + this.x + ", " + this.y + ")";
    }
}

