/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.Game;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EntityTemplate;
import net.sf.hale.entity.Item;
import net.sf.hale.rules.Quality;
import net.sf.hale.util.SimpleJSONObject;

public class ItemTemplate
extends EntityTemplate {
    private final Quality defaultQuality;
    private final int valueInCPOver100;
    private final int weightInGrams;
    private final boolean isIngredient;
    private final boolean isQuest;
    private final String useText;
    private final int useAP;

    public ItemTemplate(String string, SimpleJSONObject simpleJSONObject) {
        super(string, simpleJSONObject);
        if (simpleJSONObject.containsKey("defaultQuality")) {
            String string2 = simpleJSONObject.get("defaultQuality", null);
            this.defaultQuality = Game.ruleset.getItemQuality(string2);
        } else {
            this.defaultQuality = null;
        }
        this.valueInCPOver100 = simpleJSONObject.get("value", 0);
        this.weightInGrams = simpleJSONObject.get("weight", 0);
        this.isIngredient = simpleJSONObject.containsKey("isIngredient") ? simpleJSONObject.get("isIngredient", false) : false;
        this.isQuest = simpleJSONObject.containsKey("isQuest") ? simpleJSONObject.get("isQuest", false) : false;
        if (!simpleJSONObject.containsKey("script")) {
            this.useText = null;
            this.useAP = 0;
        } else {
            this.useText = simpleJSONObject.containsKey("useText") ? simpleJSONObject.get("useText", null) : null;
            this.useAP = simpleJSONObject.containsKey("useAP") ? simpleJSONObject.get("useAP", 0) : 0;
        }
    }

    protected ItemTemplate(String string, ItemTemplate itemTemplate, CreatedItem createdItem) {
        super(string, itemTemplate, createdItem);
        this.defaultQuality = itemTemplate.defaultQuality;
        this.valueInCPOver100 = createdItem.getModifiedValue(itemTemplate.valueInCPOver100);
        this.weightInGrams = itemTemplate.weightInGrams;
        this.isIngredient = itemTemplate.isIngredient;
        this.isQuest = itemTemplate.isQuest;
        this.useText = itemTemplate.useText;
        this.useAP = itemTemplate.useAP;
    }

    @Override
    public Item createInstance() {
        return new Item(this);
    }

    public boolean hasQuality() {
        return this.defaultQuality != null;
    }

    public Quality getDefaultQuality() {
        return this.defaultQuality;
    }

    public int getValueInCPOver100() {
        return this.valueInCPOver100;
    }

    public int getWeightInGrams() {
        return this.weightInGrams;
    }

    public boolean isIngredient() {
        return this.isIngredient;
    }

    public boolean isQuest() {
        return this.isQuest;
    }

    public boolean isUsable() {
        if (this.hasScript()) {
            return this.getScript().hasFunction(ScriptFunctionType.onUse);
        }
        return false;
    }

    public String getUseText() {
        return this.useText;
    }

    public int getUseAP() {
        return this.useAP;
    }

    public boolean hasPrereqsToEquip(Creature creature) {
        return true;
    }
}

