/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.ItemTemplate;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.rules.Quality;
import net.sf.hale.rules.Weight;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class ItemList
implements Iterable<Entry>,
Saveable {
    private List<Listener> listeners;
    private List<Entry> entries = new ArrayList<Entry>();

    @Override
    public Object save() {
        Object[] objectArray = new Object[this.entries.size()];
        int n = 0;
        for (Entry entry : this.entries) {
            JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
            jSONOrderedObject.put("id", entry.id);
            if (entry.quality != null) {
                jSONOrderedObject.put("quality", entry.quality);
            }
            jSONOrderedObject.put("quantity", entry.quantity);
            objectArray[n] = jSONOrderedObject;
            ++n;
        }
        return objectArray;
    }

    public void load(SimpleJSONArray simpleJSONArray) {
        this.clear();
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            String string = simpleJSONObject.get("id", null);
            Quality quality = null;
            if (simpleJSONObject.containsKey("quality")) {
                quality = Game.ruleset.getItemQuality(simpleJSONObject.get("quality", null));
            }
            int n = simpleJSONObject.get("quantity", 0);
            if (EntityManager.getItemTemplate(string) == null) continue;
            this.entries.add(new Entry(string, quality, n));
        }
    }

    public ItemList() {
        this.listeners = new ArrayList<Listener>();
    }

    public ItemList(ItemList itemList) {
        this();
        for (Entry entry : itemList.entries) {
            this.entries.add(new Entry(entry));
        }
    }

    public ItemList(SimpleJSONArray simpleJSONArray) {
        this();
        this.load(simpleJSONArray);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void validate() {
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            try {
                EntityManager.getItem(entry.id, entry.quality);
            }
            catch (Exception exception) {
                iterator.remove();
            }
        }
    }

    public void clear() {
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            this.removeEntry(i);
        }
    }

    public int size() {
        return this.entries.size();
    }

    public void addAll(ItemList itemList) {
        for (Entry entry : itemList) {
            this.add(entry.id, entry.quality, entry.quantity);
        }
    }

    public void add(String string, Quality quality, int n) {
        Object object;
        int n2;
        if (EntityManager.getItemTemplate(string).hasQuality()) {
            if (quality == null) {
                quality = EntityManager.getItemTemplate(string).getDefaultQuality();
            }
        } else {
            quality = null;
        }
        if ((n2 = this.findEntry(string, quality)) == -1) {
            object = new Entry(string, quality, n);
            this.entries.add((Entry)object);
        } else {
            object = this.entries.get(n2);
            ((Entry)object).quantity = ((Entry)object).quantity + n;
        }
        for (Listener listener : this.listeners) {
            listener.itemListItemAdded(string, quality, n);
        }
    }

    public void add(String string, String string2, int n) {
        this.add(string, Game.ruleset.getItemQuality(string2), n);
    }

    public void add(String string, String string2) {
        this.add(string, Game.ruleset.getItemQuality(string2), 1);
    }

    public void add(String string, int n) {
        this.add(string, (Quality)null, n);
    }

    public void add(String string) {
        this.add(string, (Quality)null, 1);
    }

    public void add(Item item, int n) {
        this.add(item.getTemplate().getID(), item.getQuality(), n);
    }

    public void add(Item item) {
        this.add(item.getTemplate().getID(), item.getQuality(), 1);
    }

    public int remove(String string, int n) {
        int n2 = n;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get(i).id.equals(string)) continue;
            if (this.entries.get(i).quantity > n2) {
                Entry entry = this.entries.get(i);
                entry.quantity = entry.quantity - n2;
                n2 = 0;
                break;
            }
            if (this.entries.get(i).quantity == n2) {
                this.removeEntry(i);
                n2 = 0;
                break;
            }
            n2 -= this.entries.get(i).quantity;
            this.removeEntry(i);
        }
        return n - n2;
    }

    public int remove(String string, Quality quality, int n) {
        int n2 = this.findEntry(string, quality);
        if (n2 == -1) {
            return 0;
        }
        int n3 = this.entries.get(n2).quantity;
        if (n3 > n) {
            this.entries.get(n2).quantity = n3 - n;
            return n;
        }
        if (n3 == n) {
            this.removeEntry(n2);
            return n;
        }
        this.removeEntry(n2);
        return n3;
    }

    public int remove(Item item, int n) {
        return this.remove(item.getTemplate().getID(), item.getQuality(), n);
    }

    public int remove(Item item) {
        return this.remove(item.getTemplate().getID(), item.getQuality(), 1);
    }

    public boolean contains(Item item, int n) {
        int n2 = this.findEntry(item.getTemplate().getID(), item.getQuality());
        if (n2 == -1) {
            return false;
        }
        return this.entries.get(n2).quantity >= n;
    }

    public boolean contains(Item item) {
        return this.contains(item, 1);
    }

    public boolean contains(String string) {
        for (Entry entry : this.entries) {
            if (!entry.id.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string, String string2) {
        int n = this.findEntry(string, Game.ruleset.getItemQuality(string2));
        return n != -1;
    }

    public int getQuantity(Item item) {
        int n = this.findEntry(item.getTemplate().getID(), item.getQuality());
        if (n == -1) {
            return 0;
        }
        return this.entries.get(n).quantity;
    }

    public int getQuantity(String string) {
        int n = 0;
        for (Entry entry : this.entries) {
            if (!entry.id.equals(string)) continue;
            n += entry.quantity;
        }
        return n;
    }

    public Entry find(String string, Quality quality) {
        int n = this.findEntry(string, quality);
        if (n == -1) {
            return null;
        }
        return this.entries.get(n);
    }

    public Entry find(String string, String string2) {
        if (string2 == null) {
            return this.find(string, (Quality)null);
        }
        return this.find(string, Game.ruleset.getItemQuality(string2));
    }

    private int findEntry(String string, Quality quality) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (!entry.id.equals(string) || entry.getQuality() != quality) continue;
            return i;
        }
        return -1;
    }

    public Entry getRandomEntry() {
        if (this.entries.size() == 0) {
            return null;
        }
        if (this.entries.size() == 1) {
            return this.entries.get(0);
        }
        int n = Game.dice.rand(0, this.entries.size() - 1);
        return this.entries.get(n);
    }

    public void sort() {
        Collections.sort(this.entries);
    }

    public Weight getTotalWeight() {
        int n = 0;
        for (Entry entry : this.entries) {
            ItemTemplate itemTemplate = EntityManager.getItemTemplate(entry.id);
            n += itemTemplate.getWeightInGrams() * entry.quantity;
        }
        return new Weight(n);
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    private void removeEntry(int n) {
        Entry entry = this.entries.get(n);
        entry.quantity = 0;
        Iterator<Listener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener listener = iterator.next();
            if (!listener.itemListEntryRemoved(entry)) continue;
            iterator.remove();
        }
        this.entries.remove(n);
    }

    public static class Entry
    implements Comparable<Entry> {
        private final String id;
        private final String quality;
        private int quantity;

        private Entry(String string, Quality quality, int n) {
            this.id = string;
            this.quality = quality != null ? quality.getName() : null;
            this.quantity = n;
        }

        private Entry(Entry entry) {
            this.id = entry.id;
            this.quality = entry.quality;
            this.quantity = entry.quantity;
        }

        public String getID() {
            return this.id;
        }

        public Quality getQuality() {
            return Game.ruleset.getItemQuality(this.quality);
        }

        public int getQuantity() {
            return this.quantity;
        }

        public boolean hasQuality() {
            return this.quality != null;
        }

        public int getRandomQuantity() {
            if (this.quantity == 1) {
                return 1;
            }
            if (this.quantity == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return Game.dice.rand(1, this.quantity);
        }

        public Item createItem() {
            if (this.hasQuality()) {
                return EntityManager.getItem(this.id, this.quality);
            }
            return EntityManager.getItem(this.id);
        }

        @Override
        public int compareTo(Entry entry) {
            ItemTemplate itemTemplate = EntityManager.getItemTemplate(this.id);
            ItemTemplate itemTemplate2 = EntityManager.getItemTemplate(entry.id);
            int n = itemTemplate.getName().compareTo(itemTemplate2.getName());
            if (n != 0) {
                return n;
            }
            if (this.quality != null && entry.quality != null) {
                return this.quality.compareTo(entry.quality);
            }
            if (this.quality == null && entry.quality == null) {
                return 0;
            }
            if (this.quality == null) {
                return -1;
            }
            return 1;
        }
    }

    public static interface Listener {
        public void itemListItemAdded(String var1, Quality var2, int var3);

        public boolean itemListEntryRemoved(Entry var1);
    }
}

