/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import de.matthiasmann.twl.Widget;
import net.sf.hale.Game;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.area.Area;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.ItemTemplate;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.rules.Quality;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.view.ItemDetailsWindow;

public class Item
extends Entity {
    private final ItemTemplate template;
    private String quality;
    private int qualityValue;

    @Override
    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        super.load(simpleJSONObject, area, referenceHandler);
        if (simpleJSONObject.containsKey("quality")) {
            this.setQuality(simpleJSONObject.get("quality", null));
        }
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        if (this.quality != null) {
            jSONOrderedObject.put("quality", this.quality);
        }
        return jSONOrderedObject;
    }

    protected Item(ItemTemplate itemTemplate) {
        super(itemTemplate);
        this.template = itemTemplate;
    }

    @Override
    public ItemTemplate getTemplate() {
        return this.template;
    }

    protected void setQuality(String string) {
        if (this.template.hasQuality()) {
            Quality quality = Game.ruleset.getItemQuality(string);
            this.quality = string;
            this.qualityValue = this.template.getValueInCPOver100() * quality.getValueAdjustment() / 100;
        } else {
            if (string != null) {
                Logger.appendToWarningLog("Quality cannot be set for " + this.getTemplate().getID());
            }
            this.quality = null;
            this.qualityValue = this.template.getValueInCPOver100();
        }
    }

    public Quality getQuality() {
        return Game.ruleset.getItemQuality(this.quality);
    }

    public int getQualityValue() {
        return this.qualityValue;
    }

    public String getLongName() {
        if (this.getTemplate().hasQuality()) {
            return this.quality + " " + this.getTemplate().getName();
        }
        return this.getTemplate().getName();
    }

    public boolean canUse(Creature creature) {
        if (!this.template.isUsable()) {
            return false;
        }
        if (!creature.timer.canPerformAction(this.template.getUseAP())) {
            return false;
        }
        if (this.template.getScript().hasFunction(ScriptFunctionType.canUse)) {
            Object object = this.template.getScript().executeFunction(ScriptFunctionType.canUse, this, creature);
            return Boolean.TRUE.equals(object);
        }
        return true;
    }

    public boolean use(Creature creature) {
        if (!this.template.isUsable()) {
            return false;
        }
        if (!creature.timer.performAction(this.template.getUseAP())) {
            return false;
        }
        this.template.getScript().executeFunction(ScriptFunctionType.onUse, this, creature);
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Item)) {
            return false;
        }
        Item item = (Item)object;
        if (!this.template.getID().equals(item.template.getID())) {
            return false;
        }
        if (this.quality != null) {
            return this.quality.equals(item.quality);
        }
        return true;
    }

    public Runnable getExamineDetailsCallback(int n, int n2) {
        return new ExamineDetailsCallback(n, n2);
    }

    public Runnable getUseCallback(Creature creature) {
        return new UseCallback(creature);
    }

    private class ExamineDetailsCallback
    implements Runnable {
        private final int x;
        private final int y;

        private ExamineDetailsCallback(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        @Override
        public void run() {
            ItemDetailsWindow itemDetailsWindow = new ItemDetailsWindow(Item.this);
            itemDetailsWindow.setPosition(this.x - itemDetailsWindow.getWidth() / 2, this.y - itemDetailsWindow.getHeight() / 2);
            Game.mainViewer.add((Widget)itemDetailsWindow);
            Game.mainViewer.getMenu().hide();
        }
    }

    private class UseCallback
    implements Runnable {
        private Creature parent;

        private UseCallback(Creature creature) {
            this.parent = creature;
        }

        @Override
        public void run() {
            Item.this.use(this.parent);
            Game.mainViewer.getMenu().hide();
        }
    }
}

