/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Widget;
import java.util.HashMap;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.entity.Ammo;
import net.sf.hale.entity.Armor;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.ItemTemplate;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Weapon;
import net.sf.hale.entity.WeaponTemplate;
import net.sf.hale.icon.SubIcon;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.loading.Saveable;
import net.sf.hale.rules.ArmorType;
import net.sf.hale.rules.BaseWeapon;
import net.sf.hale.rules.Currency;
import net.sf.hale.rules.Merchant;
import net.sf.hale.rules.Quality;
import net.sf.hale.rules.Weight;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.widgets.MultipleItemPopup;
import net.sf.hale.widgets.RightClickMenu;

public class Inventory
implements ItemList.Listener,
Saveable {
    private final Creature parent;
    private final ItemList unequippedItems;
    private final Map<Slot, EquippableItem> equippedItems;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        JSONOrderedObject jSONOrderedObject2 = new JSONOrderedObject();
        for (Slot slot : Slot.values()) {
            EquippableItem equippableItem = this.equippedItems.get((Object)slot);
            if (equippableItem == null) continue;
            JSONOrderedObject jSONOrderedObject3 = new JSONOrderedObject();
            jSONOrderedObject3.put("id", equippableItem.getTemplate().getID());
            if (equippableItem.getTemplate().hasQuality()) {
                jSONOrderedObject3.put("quality", equippableItem.getQuality().getName());
            }
            if (equippableItem.getEffects().size() > 0) {
                jSONOrderedObject3.put("effects", equippableItem.getEffects().save());
            }
            jSONOrderedObject2.put(slot.name(), jSONOrderedObject3);
        }
        jSONOrderedObject.put("equipped", jSONOrderedObject2);
        jSONOrderedObject.put("unequipped", this.unequippedItems.save());
        return jSONOrderedObject;
    }

    public void load(SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler) throws LoadGameException {
        if (simpleJSONObject.containsKey("createdItems")) {
            for (Object object : simpleJSONObject.getArray("createdItems")) {
                CreatedItem createdItem = CreatedItem.load(((SimpleJSONArrayEntry)object).getObject());
                Game.curCampaign.addCreatedItem(createdItem);
            }
        }
        if (simpleJSONObject.containsKey("equipped")) {
            SimpleJSONObject simpleJSONObject2 = simpleJSONObject.getObject("equipped");
            for (Slot slot : Slot.values()) {
                if (!simpleJSONObject2.containsKey(slot.toString())) continue;
                SimpleJSONObject simpleJSONObject3 = simpleJSONObject2.getObject(slot.toString());
                String string = simpleJSONObject3.get("id", null);
                EquippableItem equippableItem = simpleJSONObject3.containsKey("quality") ? (EquippableItem)EntityManager.getItem(string, simpleJSONObject3.get("quality", null)) : (EquippableItem)EntityManager.getItem(string);
                if (equippableItem == null) {
                    Logger.appendToWarningLog("Item " + string + " cannot be loaded.");
                    continue;
                }
                if (referenceHandler != null && simpleJSONObject3.containsKey("effects")) {
                    equippableItem.getEffects().load(simpleJSONObject3.getObject("effects"), referenceHandler, equippableItem);
                    equippableItem.getEffects().startAnimations();
                    for (Effect effect : equippableItem.getEffects()) {
                        equippableItem.applyEffectBonuses(effect);
                    }
                }
                this.equip(equippableItem, slot, false);
            }
        }
        if (simpleJSONObject.containsKey("unequipped")) {
            this.unequippedItems.load(simpleJSONObject.getArray("unequipped"));
        }
    }

    public Inventory(Creature creature) {
        this.parent = creature;
        this.unequippedItems = new ItemList();
        this.unequippedItems.addListener(this);
        this.equippedItems = new HashMap<Slot, EquippableItem>();
    }

    public Inventory(Inventory inventory, Creature creature) {
        this.parent = creature;
        this.unequippedItems = new ItemList(inventory.unequippedItems);
        this.unequippedItems.addListener(this);
        this.equippedItems = new HashMap<Slot, EquippableItem>();
        for (Slot slot : inventory.equippedItems.keySet()) {
            EquippableItem equippableItem = inventory.equippedItems.get((Object)slot);
            this.equip((EquippableItem)EntityManager.getItem(equippableItem.getTemplate().getID(), equippableItem.getQuality()), slot, false);
        }
    }

    public void endAllAnimations() {
        for (Slot slot : Slot.values()) {
            EquippableItem equippableItem = this.equippedItems.get((Object)slot);
            if (equippableItem == null) continue;
            equippableItem.getEffects().endAllAnimations();
        }
    }

    private void unequip(Slot slot, boolean bl) {
        EquippableItem equippableItem = this.equippedItems.get((Object)slot);
        if (equippableItem != null) {
            equippableItem.getEffects().endAllAnimations();
            equippableItem.setOwner(null);
            if (bl) {
                this.unequippedItems.add(equippableItem);
            }
            this.equippedItems.remove((Object)slot);
            this.parent.stats.changeEquipment(equippableItem.getTemplate().getType());
            this.parent.stats.removeAll(equippableItem.getBonusList());
            this.parent.removeSubIcon(equippableItem, slot);
            if (equippableItem.getTemplate().hasScript()) {
                equippableItem.getTemplate().getScript().executeFunction(ScriptFunctionType.onUnequipItem, this.parent, equippableItem);
            }
        }
    }

    private void equip(EquippableItem equippableItem, Slot slot, boolean bl) {
        this.equippedItems.put(slot, equippableItem);
        equippableItem.setOwner(this.parent);
        this.unequippedItems.remove(equippableItem);
        if (bl) {
            this.parent.stats.changeEquipment(equippableItem.getTemplate().getType());
            this.parent.stats.addAll(equippableItem.getBonusList());
        }
        this.parent.addSubIcon(equippableItem, slot);
        if (equippableItem.getTemplate().hasScript()) {
            equippableItem.getTemplate().getScript().executeFunction(ScriptFunctionType.onEquipItem, this.parent, equippableItem);
        }
    }

    private boolean checkAndEquip(EquippableItem equippableItem, Slot slot, boolean bl) {
        EquippableItem equippableItem2;
        if (slot == null) {
            slot = this.getDefaultSlot(equippableItem);
        }
        if (!this.parent.timer.canPerformEquipAction(equippableItem)) {
            return false;
        }
        if (!slot.matchesItemType(equippableItem)) {
            return false;
        }
        if (!this.hasPrereqsToEquip(equippableItem)) {
            return false;
        }
        if (equippableItem instanceof Weapon && slot == Slot.OffHand && !this.parent.stats.has(Bonus.Type.DualWieldTraining)) {
            return false;
        }
        EquippableItem equippableItem3 = this.equippedItems.get((Object)slot);
        if (equippableItem3 != null && !equippableItem3.getTemplate().isUnequippable()) {
            return false;
        }
        Slot slot2 = null;
        if (equippableItem instanceof Weapon && ((Weapon)(equippableItem2 = (Weapon)equippableItem)).isTwoHanded()) {
            slot2 = Slot.OffHand;
        }
        if (slot == Slot.OffHand && (equippableItem2 = this.getEquippedMainHand()) != null && ((Weapon)equippableItem2).isTwoHanded()) {
            slot2 = Slot.MainHand;
        }
        equippableItem2 = null;
        if (slot2 != null && (equippableItem2 = this.equippedItems.get((Object)slot2)) != null && !equippableItem2.getTemplate().isUnequippable()) {
            return false;
        }
        if (bl) {
            this.parent.timer.performEquipAction(equippableItem);
            if (equippableItem3 != null) {
                this.unequip(slot, true);
            }
            if (equippableItem2 != null) {
                this.unequip(slot2, true);
            }
            this.equip(equippableItem, slot, true);
            if (Game.mainViewer != null) {
                Game.mainViewer.updateInterface();
            }
        }
        return true;
    }

    public boolean canEquip(EquippableItem equippableItem, Slot slot) {
        return this.checkAndEquip(equippableItem, slot, false);
    }

    public boolean equipItem(String string, String string2) {
        EquippableItem equippableItem = (EquippableItem)EntityManager.getItem(string, string2);
        return this.checkAndEquip(equippableItem, null, true);
    }

    public boolean equipItem(EquippableItem equippableItem, Slot slot) {
        return this.checkAndEquip(equippableItem, slot, true);
    }

    public void addAndEquip(EquippableItem equippableItem) {
        this.unequippedItems.add(equippableItem);
        this.checkAndEquip(equippableItem, null, true);
    }

    public void addAndEquip(EquippableItem equippableItem, Slot slot) {
        this.unequippedItems.add(equippableItem);
        this.checkAndEquip(equippableItem, slot, true);
    }

    public void addAndEquip(String string, String string2) {
        EquippableItem equippableItem = (EquippableItem)EntityManager.getItem(string, string2);
        this.unequippedItems.add(equippableItem);
        this.checkAndEquip(equippableItem, null, true);
    }

    public void addAndEquip(String string) {
        EquippableItem equippableItem = (EquippableItem)EntityManager.getItem(string);
        this.unequippedItems.add(equippableItem);
        this.checkAndEquip(equippableItem, null, true);
    }

    public boolean hasPrereqsToEquip(EquippableItem equippableItem) {
        if (equippableItem instanceof Weapon) {
            BaseWeapon baseWeapon = ((Weapon)equippableItem).getTemplate().getBaseWeapon();
            return this.parent.stats.hasWeaponProficiency(baseWeapon.getName());
        }
        if (equippableItem instanceof Armor) {
            ArmorType armorType = ((Armor)equippableItem).getTemplate().getArmorType();
            return this.parent.stats.hasArmorProficiency(armorType.getName());
        }
        return true;
    }

    private Slot getDefaultSlot(EquippableItem equippableItem) {
        switch (equippableItem.getTemplate().getType()) {
            case Weapon: {
                Weapon weapon = this.getEquippedMainHand();
                if (weapon != null && !weapon.isTwoHanded() && this.getEquippedOffHand() == null && this.parent.stats.has(Bonus.Type.DualWieldTraining) && !((Weapon)equippableItem).isTwoHanded()) {
                    return Slot.OffHand;
                }
                return Slot.MainHand;
            }
            case Ring: {
                if (this.equippedItems.get((Object)Slot.LeftRing) == null) {
                    return Slot.LeftRing;
                }
                return Slot.RightRing;
            }
            case Armor: {
                return Slot.Armor;
            }
            case Gloves: {
                return Slot.Gloves;
            }
            case Helmet: {
                return Slot.Helmet;
            }
            case Cloak: {
                return Slot.Cloak;
            }
            case Boots: {
                return Slot.Boots;
            }
            case Belt: {
                return Slot.Belt;
            }
            case Amulet: {
                return Slot.Amulet;
            }
            case Ammo: {
                return Slot.Quiver;
            }
            case Shield: {
                return Slot.OffHand;
            }
        }
        return Slot.MainHand;
    }

    public Creature getParent() {
        return this.parent;
    }

    public boolean hasAmmoEquippedForWeapon() {
        Weapon weapon = this.parent.getMainHandWeapon();
        switch (weapon.getTemplate().getWeaponType()) {
            case Ranged: {
                return weapon.getTemplate().isAmmoForThisWeapon(this.getEquippedQuiver());
            }
        }
        return true;
    }

    public Weapon getEquippedMainHand() {
        return (Weapon)this.equippedItems.get((Object)Slot.MainHand);
    }

    public EquippableItem getEquippedOffHand() {
        return this.equippedItems.get((Object)Slot.OffHand);
    }

    public Armor getEquippedShield() {
        EquippableItem equippableItem = this.equippedItems.get((Object)Slot.OffHand);
        if (equippableItem == null) {
            return null;
        }
        if (equippableItem instanceof Armor) {
            return (Armor)equippableItem;
        }
        return null;
    }

    public Weapon getEquippedOffHandWeapon() {
        EquippableItem equippableItem = this.equippedItems.get((Object)Slot.OffHand);
        if (equippableItem == null) {
            return null;
        }
        if (equippableItem instanceof Weapon) {
            return (Weapon)equippableItem;
        }
        return null;
    }

    public Armor getEquippedArmor() {
        return (Armor)this.equippedItems.get((Object)Slot.Armor);
    }

    public Armor getEquippedGloves() {
        return (Armor)this.equippedItems.get((Object)Slot.Gloves);
    }

    public Armor getEquippedHelmet() {
        return (Armor)this.equippedItems.get((Object)Slot.Helmet);
    }

    public Armor getEquippedBoots() {
        return (Armor)this.equippedItems.get((Object)Slot.Boots);
    }

    public EquippableItem getEquippedCloak() {
        return this.equippedItems.get((Object)Slot.Cloak);
    }

    public EquippableItem getEquippedBelt() {
        return this.equippedItems.get((Object)Slot.Belt);
    }

    public EquippableItem getEquippedAmulet() {
        return this.equippedItems.get((Object)Slot.Amulet);
    }

    public EquippableItem getEquippedRightRing() {
        return this.equippedItems.get((Object)Slot.RightRing);
    }

    public EquippableItem getEquippedLeftRing() {
        return this.equippedItems.get((Object)Slot.LeftRing);
    }

    public Ammo getEquippedQuiver() {
        return (Ammo)this.equippedItems.get((Object)Slot.Quiver);
    }

    public EquippableItem getEquippedItem(Slot slot) {
        return this.equippedItems.get((Object)slot);
    }

    public EquippableItem removeEquippedItem(String string) {
        return this.removeEquippedItem(Slot.valueOf(string));
    }

    public EquippableItem removeEquippedItem(Slot slot) {
        EquippableItem equippableItem = this.equippedItems.get((Object)slot);
        if (equippableItem != null) {
            this.unequip(slot, false);
        }
        return equippableItem;
    }

    public ItemList getUnequippedItems() {
        return this.unequippedItems;
    }

    public boolean isEmptyOtherThanDefaultClothes() {
        if (this.unequippedItems.size() > 0) {
            return false;
        }
        for (Slot slot : Slot.values()) {
            if (this.equippedItems.get((Object)slot) == null || slot == Slot.Armor && this.equippedItems.get((Object)slot).getTemplate().getID().equals(Game.ruleset.getString("DefaultClothes"))) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        for (Slot slot : Slot.values()) {
            this.unequip(slot, false);
        }
        this.unequippedItems.clear();
    }

    public Weight getTotalWeight() {
        int n = this.unequippedItems.getTotalWeight().grams;
        for (Slot slot : Slot.values()) {
            EquippableItem equippableItem = this.equippedItems.get((Object)slot);
            if (equippableItem == null) continue;
            n += equippableItem.getTemplate().getWeightInGrams();
        }
        return new Weight(n);
    }

    public boolean hasBoth(Item item, Item item2) {
        if (item.equals(item2)) {
            return this.getTotalQuantity(item) >= 2;
        }
        return this.getTotalQuantity(item) >= 1 && this.getTotalQuantity(item2) >= 1;
    }

    public int getTotalQuantity(Item item) {
        int n = this.unequippedItems.getQuantity(item);
        for (Slot slot : Slot.values()) {
            if (!item.equals(this.equippedItems.get((Object)slot))) continue;
            ++n;
        }
        return n;
    }

    public int getTotalQuantity(String string) {
        int n = this.unequippedItems.getQuantity(string);
        for (Slot slot : Slot.values()) {
            Item item = this.equippedItems.get((Object)slot);
            if (item == null || !item.getTemplate().getID().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public int remove(Item item) {
        return this.remove(item, 1);
    }

    public int remove(Item item, int n) {
        int n2 = this.unequippedItems.remove(item, n);
        if (n2 == n) {
            return n;
        }
        int n3 = 0;
        for (Slot slot : Slot.values()) {
            if (!item.equals(this.equippedItems.get((Object)slot))) continue;
            this.unequip(slot, false);
            if (++n3 + n2 != n) continue;
            return n;
        }
        return n3 + n2;
    }

    public int remove(String string) {
        return this.remove(string, 1);
    }

    public int remove(String string, int n) {
        int n2 = this.unequippedItems.remove(string, n);
        if (n2 == n) {
            return n;
        }
        int n3 = 0;
        for (Slot slot : Slot.values()) {
            if (this.equippedItems.get((Object)slot) == null || !string.equals(this.equippedItems.get((Object)slot).getTemplate().getID())) continue;
            this.unequip(slot, false);
            if (++n3 + n2 != n) continue;
            return n;
        }
        return n3 + n2;
    }

    public Slot getSlot(Item item) {
        for (Slot slot : Slot.values()) {
            if (!item.equals(this.equippedItems.get((Object)slot))) continue;
            return slot;
        }
        return null;
    }

    public boolean isEquipped(Item item) {
        return this.getSlot(item) != null;
    }

    public void elapseTime(int n) {
        for (Slot slot : Slot.values()) {
            EquippableItem equippableItem = this.equippedItems.get((Object)slot);
            if (equippableItem == null) continue;
            equippableItem.elapseTime(n);
        }
    }

    public void validateItems() {
        this.unequippedItems.validate();
    }

    public Runnable getTakeAndWieldCallback(EquippableItem equippableItem, Container container) {
        return new TakeAndWieldCallback(equippableItem, container);
    }

    public Runnable getUnequipCallback(Slot slot) {
        return new UnequipCallback(slot);
    }

    public Runnable getEquipCallback(EquippableItem equippableItem, Slot slot) {
        return new EquipCallback(equippableItem, slot);
    }

    public Runnable getGiveCallback(Item item, int n) {
        return new ShowGiveMenuCallback(item, n);
    }

    public Runnable getGiveEquippedCallback(Slot slot, Creature creature) {
        return new GiveEquippedCallback(slot, creature);
    }

    public Runnable getGiveCallback(Item item, int n, Creature creature) {
        return new GiveCallback(item, n, creature);
    }

    public Runnable getDropCallback(Item item, int n) {
        return new DropCallback(item, n);
    }

    public Runnable getDropEquippedCallback(Slot slot) {
        return new DropEquippedCallback(slot);
    }

    public Runnable getTakeCallback(Item item, int n, Container container) {
        return new TakeCallback(item, n, container);
    }

    public Runnable getTakeAllCallback(Container container) {
        return new TakeAllCallback(container);
    }

    public Runnable getBuyCallback(Item item, int n, Merchant merchant) {
        return new BuyCallback(item, n, merchant);
    }

    public Runnable getSellCallback(Item item, int n, Merchant merchant) {
        return new SellCallback(item, n, merchant);
    }

    public Runnable getSellEquippedCallback(Slot slot, Merchant merchant) {
        return new SellEquippedCallback(slot, merchant);
    }

    @Override
    public void itemListItemAdded(String string, Quality quality, int n) {
        ItemTemplate itemTemplate = EntityManager.getItemTemplate(string);
        if (itemTemplate.hasScript()) {
            Item item = EntityManager.getItem(string, quality);
            item.getTemplate().getScript().executeFunction(ScriptFunctionType.onAddItem, this.parent, item);
        }
    }

    @Override
    public boolean itemListEntryRemoved(ItemList.Entry entry) {
        return false;
    }

    private class SellEquippedCallback
    implements Runnable {
        private Slot slot;
        private Merchant merchant;

        private SellEquippedCallback(Slot slot, Merchant merchant) {
            this.slot = slot;
            this.merchant = merchant;
        }

        @Override
        public void run() {
            Item item = (Item)Inventory.this.equippedItems.get((Object)this.slot);
            if (item.getTemplate().isQuest()) {
                return;
            }
            Inventory.this.unequip(this.slot, false);
            this.merchant.buyItem(item, Inventory.this.parent);
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class SellCallback
    extends MultipleCallback {
        private Merchant merchant;

        private SellCallback(Item item, int n, Merchant merchant) {
            super(item, n, "Sell");
            this.merchant = merchant;
        }

        @Override
        public String getValueText(int n) {
            int n2 = this.merchant.getCurrentBuyPercentage();
            return "Price: " + Currency.getPlayerSellCost(this.item, n, n2).shortString();
        }

        @Override
        public void performItemAction(int n) {
            this.merchant.buyItem(this.item, Inventory.this.parent, n);
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class BuyCallback
    extends MultipleCallback {
        private Merchant merchant;

        private BuyCallback(Item item, int n, Merchant merchant) {
            super(item, n, "Buy");
            this.merchant = merchant;
        }

        @Override
        public String getValueText(int n) {
            int n2 = this.merchant.getCurrentSellPercentage();
            return "Price: " + Currency.getPlayerBuyCost(this.item, n, n2).shortString();
        }

        @Override
        public void performItemAction(int n) {
            this.merchant.sellItem(this.item, Inventory.this.parent, n);
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class TakeCallback
    extends MultipleCallback {
        private Container container;

        private TakeCallback(Item item, int n, Container container) {
            super(item, n, "Take");
            this.container = container;
        }

        @Override
        public void performItemAction(int n) {
            if (!((Inventory)Inventory.this).parent.timer.performAction(Game.ruleset.getValue("PickUpItemCost"))) {
                return;
            }
            Inventory.this.unequippedItems.add(this.item);
            this.container.getCurrentItems().remove(this.item, n);
            if (this.container.getCurrentItems().size() == 0 && this.container.getTemplate().isTemporary()) {
                Game.curCampaign.curArea.removeEntity(this.container);
            }
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class DropEquippedCallback
    implements Runnable {
        private Slot slot;

        private DropEquippedCallback(Slot slot) {
            this.slot = slot;
        }

        @Override
        public void run() {
            Item item = (Item)Inventory.this.equippedItems.get((Object)this.slot);
            if (item.getTemplate().isQuest()) {
                return;
            }
            if (!((Inventory)Inventory.this).parent.timer.performAction(Game.ruleset.getValue("DropItemCost"))) {
                return;
            }
            Container container = Game.mainViewer.containerWindow.getContainer();
            if (container != null) {
                item.setLocation(container.getLocation());
            } else {
                item.setLocation(Inventory.this.parent.getLocation());
            }
            Inventory.this.unequip(this.slot, false);
            Game.curCampaign.curArea.addItem(item, 1);
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class DropCallback
    extends MultipleCallback {
        private DropCallback(Item item, int n) {
            super(item, n, "Drop");
        }

        @Override
        public void performItemAction(int n) {
            if (this.item.getTemplate().isQuest()) {
                return;
            }
            if (!((Inventory)Inventory.this).parent.timer.performAction(Game.ruleset.getValue("DropItemCost"))) {
                return;
            }
            Container container = Game.mainViewer.containerWindow.getContainer();
            if (container != null) {
                this.item.setLocation(container.getLocation());
            } else {
                this.item.setLocation(Inventory.this.parent.getLocation());
            }
            Game.curCampaign.curArea.addItem(this.item, n);
            Inventory.this.unequippedItems.remove(this.item, n);
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class GiveCallback
    extends MultipleCallback {
        private Creature target;

        private GiveCallback(Item item, int n, Creature creature) {
            super(item, n, "Give");
            this.target = creature;
        }

        @Override
        public void performItemAction(int n) {
            if (!((Inventory)Inventory.this).parent.timer.performAction(Game.ruleset.getValue("GiveItemCost"))) {
                return;
            }
            Inventory.this.unequippedItems.remove(this.item, n);
            this.target.inventory.getUnequippedItems().add(this.item, n);
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class ShowGiveMenuCallback
    implements Runnable {
        private Item item;
        private int maxQuantity;

        private ShowGiveMenuCallback(Item item, int n) {
            this.item = item;
            this.maxQuantity = n;
        }

        @Override
        public void run() {
            RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
            rightClickMenu.removeMenuLevelsAbove(1);
            rightClickMenu.addMenuLevel("Give");
            for (PC pC : Game.curCampaign.party) {
                if (pC == Inventory.this.parent || pC.isSummoned()) continue;
                Button button = new Button();
                button.setText(pC.getTemplate().getName());
                button.addCallback((Runnable)new GiveCallback(this.item, this.maxQuantity, pC));
                rightClickMenu.addButton(button);
            }
            rightClickMenu.show();
        }
    }

    private abstract class MultipleCallback
    implements MultipleItemPopup.Callback {
        protected final Item item;
        private final int maxQuantity;
        private final String labelText;

        private MultipleCallback(Item item, int n, String string) {
            this.item = item;
            this.maxQuantity = n;
            this.labelText = string;
        }

        @Override
        public void run() {
            if (this.maxQuantity == 1) {
                this.performItemAction(1);
            } else {
                MultipleItemPopup multipleItemPopup = new MultipleItemPopup((Widget)Game.mainViewer);
                multipleItemPopup.openPopupCentered(this);
            }
        }

        @Override
        public String getLabelText() {
            return this.labelText;
        }

        @Override
        public int getMaximumQuantity() {
            return this.maxQuantity;
        }

        @Override
        public String getValueText(int n) {
            return "";
        }
    }

    private class GiveEquippedCallback
    implements Runnable {
        private Creature target;
        private Slot slot;

        private GiveEquippedCallback(Slot slot, Creature creature) {
            this.slot = slot;
            this.target = creature;
        }

        @Override
        public void run() {
            if (!((Inventory)Inventory.this).parent.timer.performAction(Game.ruleset.getValue("GiveItemCost"))) {
                return;
            }
            EquippableItem equippableItem = (EquippableItem)Inventory.this.equippedItems.get((Object)this.slot);
            Inventory.this.unequip(this.slot, false);
            this.target.inventory.getUnequippedItems().add(equippableItem);
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class TakeAllCallback
    implements Runnable {
        private Container container;

        private TakeAllCallback(Container container) {
            this.container = container;
        }

        @Override
        public void run() {
            ItemList itemList = this.container.getCurrentItems();
            for (ItemList.Entry entry : itemList) {
                if (!((Inventory)Inventory.this).parent.timer.performAction(Game.ruleset.getValue("PickUpItemCost"))) {
                    return;
                }
                Inventory.this.unequippedItems.add(entry.getID(), entry.getQuality(), entry.getQuantity());
            }
            this.container.getCurrentItems().clear();
            if (this.container.getTemplate().isTemporary()) {
                Game.curCampaign.curArea.removeEntity(this.container);
            }
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class EquipCallback
    implements Runnable {
        private Slot slot;
        private EquippableItem item;

        private EquipCallback(EquippableItem equippableItem, Slot slot) {
            this.slot = slot;
            this.item = equippableItem;
        }

        @Override
        public void run() {
            Inventory.this.equipItem(this.item, this.slot);
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class UnequipCallback
    implements Runnable {
        private Slot slot;

        private UnequipCallback(Slot slot) {
            this.slot = slot;
        }

        @Override
        public void run() {
            if (!((Inventory)Inventory.this).parent.timer.performEquipAction(Inventory.this.getEquippedItem(this.slot))) {
                return;
            }
            Inventory.this.unequip(this.slot, true);
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private class TakeAndWieldCallback
    implements Runnable {
        private EquippableItem item;
        private Container container;

        private TakeAndWieldCallback(EquippableItem equippableItem, Container container) {
            this.item = equippableItem;
            this.container = container;
        }

        @Override
        public void run() {
            if (!((Inventory)Inventory.this).parent.timer.performAction(Game.ruleset.getValue("PickUpAndWieldItemCost"))) {
                return;
            }
            Inventory.this.unequippedItems.add(this.item);
            Inventory.this.equipItem(this.item, null);
            this.container.getCurrentItems().remove(this.item);
            if (this.container.getCurrentItems().size() == 0 && this.container.getTemplate().isTemporary()) {
                Game.curCampaign.curArea.removeEntity(this.container);
            }
            Game.mainViewer.getMenu().hide();
            Game.mainViewer.updateInterface();
        }
    }

    private static class GenericSlotValidator
    implements SlotValidator {
        private final EquippableItemTemplate.Type type;

        private GenericSlotValidator(EquippableItemTemplate.Type type) {
            this.type = type;
        }

        @Override
        public boolean matchesItemType(EquippableItem equippableItem) {
            return equippableItem.getTemplate().getType() == this.type;
        }
    }

    private static class OffHandSlotValidator
    implements SlotValidator {
        private OffHandSlotValidator() {
        }

        @Override
        public boolean matchesItemType(EquippableItem equippableItem) {
            EquippableItemTemplate.Type type = equippableItem.getTemplate().getType();
            switch (type) {
                case Shield: {
                    return true;
                }
                case Weapon: {
                    return ((Weapon)equippableItem).getTemplate().getHanded() != WeaponTemplate.Handed.TwoHanded;
                }
            }
            return false;
        }
    }

    private static class MainHandSlotValidator
    implements SlotValidator {
        private MainHandSlotValidator() {
        }

        @Override
        public boolean matchesItemType(EquippableItem equippableItem) {
            return equippableItem.getTemplate().getType() == EquippableItemTemplate.Type.Weapon;
        }
    }

    private static interface SlotValidator {
        public boolean matchesItemType(EquippableItem var1);
    }

    private static class OffHandSubIconGetter
    implements SubIconGetter {
        private OffHandSubIconGetter() {
        }

        @Override
        public SubIcon.Type getType(EquippableItem equippableItem) {
            switch (equippableItem.getTemplate().getType()) {
                case Shield: {
                    return SubIcon.Type.Shield;
                }
                case Weapon: {
                    return SubIcon.Type.OffHandWeapon;
                }
            }
            return null;
        }
    }

    private static class NormalSubIconGetter
    implements SubIconGetter {
        private final SubIcon.Type type;

        private NormalSubIconGetter() {
            this.type = null;
        }

        private NormalSubIconGetter(SubIcon.Type type) {
            this.type = type;
        }

        @Override
        public SubIcon.Type getType(EquippableItem equippableItem) {
            return this.type;
        }
    }

    private static interface SubIconGetter {
        public SubIcon.Type getType(EquippableItem var1);
    }

    public static enum Slot {
        MainHand(new MainHandSlotValidator(), (SubIconGetter)new NormalSubIconGetter(SubIcon.Type.MainHandWeapon)),
        OffHand(new OffHandSlotValidator(), (SubIconGetter)new OffHandSubIconGetter()),
        Armor(EquippableItemTemplate.Type.Armor, (SubIconGetter)new NormalSubIconGetter(SubIcon.Type.Torso)),
        Gloves(EquippableItemTemplate.Type.Gloves, (SubIconGetter)new NormalSubIconGetter(SubIcon.Type.Gloves)),
        Helmet(EquippableItemTemplate.Type.Helmet, (SubIconGetter)new NormalSubIconGetter(SubIcon.Type.Head)),
        Cloak(EquippableItemTemplate.Type.Cloak, (SubIconGetter)new NormalSubIconGetter(SubIcon.Type.Cloak)),
        Boots(EquippableItemTemplate.Type.Boots, (SubIconGetter)new NormalSubIconGetter(SubIcon.Type.Boots)),
        Belt(EquippableItemTemplate.Type.Belt, (SubIconGetter)new NormalSubIconGetter()),
        Amulet(EquippableItemTemplate.Type.Amulet, (SubIconGetter)new NormalSubIconGetter()),
        RightRing(EquippableItemTemplate.Type.Ring, (SubIconGetter)new NormalSubIconGetter()),
        LeftRing(EquippableItemTemplate.Type.Ring, (SubIconGetter)new NormalSubIconGetter()),
        Quiver(EquippableItemTemplate.Type.Ammo, (SubIconGetter)new NormalSubIconGetter(SubIcon.Type.Quiver));

        private final SlotValidator slotValidator;
        private final SubIconGetter subIconGetter;

        private Slot(EquippableItemTemplate.Type type, SubIconGetter subIconGetter) {
            this.slotValidator = new GenericSlotValidator(type);
            this.subIconGetter = subIconGetter;
        }

        private Slot(SlotValidator slotValidator, SubIconGetter subIconGetter) {
            this.slotValidator = slotValidator;
            this.subIconGetter = subIconGetter;
        }

        public boolean matchesItemType(EquippableItem equippableItem) {
            return this.slotValidator.matchesItemType(equippableItem);
        }

        public SubIcon.Type getSubIconType(EquippableItem equippableItem) {
            return this.subIconGetter.getType(equippableItem);
        }
    }
}

