/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.Enchantment;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.ItemTemplate;
import net.sf.hale.icon.SimpleIcon;
import net.sf.hale.icon.SubIcon;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class EquippableItemTemplate
extends ItemTemplate {
    private final boolean isUnequippable;
    private final boolean coversHair;
    private final boolean coversBeard;
    private final SimpleIcon subIcon;
    private final SubIcon.Type subIconType;
    private final Type type;
    private final List<Enchantment> enchantments;
    public static final Map<Type, Inventory.Slot[]> validSlotsForType = new EnumMap<Type, Inventory.Slot[]>(Type.class);

    public static final void initializeTypesMap() {
        EquippableItemTemplate.putInTypeMap(Type.Weapon, Inventory.Slot.MainHand, Inventory.Slot.OffHand);
        EquippableItemTemplate.putInTypeMap(Type.Armor, Inventory.Slot.Armor);
        EquippableItemTemplate.putInTypeMap(Type.Gloves, Inventory.Slot.Gloves);
        EquippableItemTemplate.putInTypeMap(Type.Helmet, Inventory.Slot.Helmet);
        EquippableItemTemplate.putInTypeMap(Type.Cloak, Inventory.Slot.Cloak);
        EquippableItemTemplate.putInTypeMap(Type.Boots, Inventory.Slot.Boots);
        EquippableItemTemplate.putInTypeMap(Type.Belt, Inventory.Slot.Belt);
        EquippableItemTemplate.putInTypeMap(Type.Amulet, Inventory.Slot.Amulet);
        EquippableItemTemplate.putInTypeMap(Type.Ring, Inventory.Slot.RightRing, Inventory.Slot.LeftRing);
        EquippableItemTemplate.putInTypeMap(Type.Ammo, Inventory.Slot.Quiver);
        EquippableItemTemplate.putInTypeMap(Type.Shield, Inventory.Slot.OffHand);
    }

    private static final void putInTypeMap(Type type, Inventory.Slot ... slotArray) {
        validSlotsForType.put(type, slotArray);
    }

    public EquippableItemTemplate(String string, SimpleJSONObject simpleJSONObject) {
        super(string, simpleJSONObject);
        Object object;
        this.type = Type.valueOf(simpleJSONObject.get("type", null));
        this.coversHair = simpleJSONObject.containsKey("coversHair") ? simpleJSONObject.get("coversHair", false) : false;
        this.coversBeard = simpleJSONObject.containsKey("coversBeard") ? simpleJSONObject.get("coversBeard", false) : false;
        this.isUnequippable = simpleJSONObject.containsKey("isUnequippable") ? simpleJSONObject.get("isUnequippable", true) : true;
        if (simpleJSONObject.containsKey("subIcon")) {
            object = simpleJSONObject.getObject("subIcon");
            this.subIconType = ((SimpleJSONObject)object).containsKey("type") ? SubIcon.Type.valueOf(((SimpleJSONObject)object).get("type", null)) : null;
            this.subIcon = new SimpleIcon((SimpleJSONObject)object);
        } else {
            this.subIcon = null;
            this.subIconType = null;
        }
        if (simpleJSONObject.containsKey("enchantments")) {
            object = new ArrayList(1);
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("enchantments")) {
                object.add(new Enchantment(simpleJSONArrayEntry.getString(), false));
            }
            this.enchantments = Collections.unmodifiableList(object);
        } else {
            this.enchantments = Collections.emptyList();
        }
    }

    protected EquippableItemTemplate(String string, EquippableItemTemplate equippableItemTemplate, CreatedItem createdItem) {
        super(string, equippableItemTemplate, createdItem);
        this.coversHair = equippableItemTemplate.coversHair;
        this.coversBeard = equippableItemTemplate.coversBeard;
        this.subIcon = equippableItemTemplate.subIcon;
        this.subIconType = equippableItemTemplate.subIconType;
        this.type = equippableItemTemplate.type;
        this.enchantments = createdItem.getEnchantments();
        this.isUnequippable = createdItem.getIsUnequippable(equippableItemTemplate);
    }

    public EquippableItemTemplate createModifiedCopy(String string, CreatedItem createdItem) {
        return new EquippableItemTemplate(string, this, createdItem);
    }

    @Override
    public EquippableItem createInstance() {
        return new EquippableItem(this);
    }

    public List<Enchantment> getEnchantments() {
        return this.enchantments;
    }

    public SubIcon.Type getSubIconTypeOverride() {
        return this.subIconType;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isUnequippable() {
        return this.isUnequippable;
    }

    public boolean coversHair() {
        return this.coversHair;
    }

    public boolean coversBeard() {
        return this.coversBeard;
    }

    public SimpleIcon getSubIcon() {
        return this.subIcon;
    }

    public static enum Type {
        Weapon,
        Armor,
        Gloves,
        Helmet,
        Cloak,
        Boots,
        Belt,
        Amulet,
        Ring,
        Ammo,
        Shield;

    }
}

