/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.ability.Effect;
import net.sf.hale.area.Area;
import net.sf.hale.bonus.BonusList;
import net.sf.hale.bonus.BonusManager;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Enchantment;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.entity.Item;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.util.SimpleJSONObject;

public class EquippableItem
extends Item {
    public final BonusManager bonuses;
    private final EquippableItemTemplate template;
    private Creature owner;

    @Override
    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        super.load(simpleJSONObject, area, referenceHandler);
    }

    @Override
    public JSONOrderedObject save() {
        return super.save();
    }

    protected EquippableItem(EquippableItemTemplate equippableItemTemplate) {
        super(equippableItemTemplate);
        this.template = equippableItemTemplate;
        this.bonuses = new BonusManager();
        for (Enchantment enchantment : equippableItemTemplate.getEnchantments()) {
            this.bonuses.addAll(enchantment.getBonuses());
        }
    }

    @Override
    public EquippableItemTemplate getTemplate() {
        return this.template;
    }

    public BonusList getBonusList() {
        BonusList bonusList = new BonusList();
        for (Effect object : this.getEffects()) {
            bonusList.addAll(object.getBonuses());
        }
        for (Enchantment enchantment : this.template.getEnchantments()) {
            bonusList.addAll(enchantment.getBonuses());
        }
        return bonusList;
    }

    protected void setOwner(Creature creature) {
        this.owner = creature;
    }

    @Override
    public boolean elapseTime(int n) {
        boolean bl = super.elapseTime(n);
        this.updateListeners();
        return bl;
    }

    @Override
    protected void applyEffectBonuses(Effect effect) {
        this.bonuses.addAll(effect.getBonuses());
        if (this.owner != null) {
            this.owner.stats.addAll(effect.getBonuses());
        }
    }

    @Override
    protected void removeEffectBonuses(Effect effect) {
        this.bonuses.removeAll(effect.getBonuses());
        if (this.owner != null) {
            this.owner.stats.removeAll(effect.getBonuses());
        }
    }

    @Override
    public String getLongName() {
        return super.getLongName();
    }
}

