/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.ability.Scriptable;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.Entity;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.util.SimpleJSONObject;

public abstract class EntityTemplate {
    private final String id;
    private final Scriptable conversation;
    private final Icon icon;
    private final String name;
    private final String description;
    private final Scriptable script;

    public EntityTemplate(String string, String string2, Icon icon) {
        this.id = string;
        this.name = string2;
        this.conversation = null;
        this.script = null;
        this.description = null;
        this.icon = icon;
    }

    public EntityTemplate(String string, SimpleJSONObject simpleJSONObject) {
        String string2;
        this.id = string;
        this.name = simpleJSONObject.get("name", null);
        this.description = simpleJSONObject.containsKey("description") ? simpleJSONObject.get("description", null) : null;
        String string3 = simpleJSONObject.get("script", null);
        if (string3 == null) {
            this.script = null;
        } else {
            string2 = ResourceManager.getScriptResourceAsString(string3);
            this.script = new Scriptable(string2, string3, false);
        }
        string2 = null;
        if (simpleJSONObject.containsKey("conversation")) {
            string2 = simpleJSONObject.get("conversation", null);
        }
        if (string2 == null) {
            this.conversation = null;
        } else {
            String string4 = ResourceManager.getScriptResourceAsString(string2);
            this.conversation = new Scriptable(string4, string2, false);
        }
        this.icon = simpleJSONObject.containsKey("icon") ? IconFactory.createIcon(simpleJSONObject.getObject("icon")) : IconFactory.emptyIcon;
    }

    protected EntityTemplate(String string, EntityTemplate entityTemplate, CreatedItem createdItem) {
        this.id = string;
        this.conversation = entityTemplate.conversation;
        this.icon = createdItem.getModifiedIcon(entityTemplate.icon);
        this.name = createdItem.getModifiedName(entityTemplate.name);
        this.description = entityTemplate.description;
        this.script = entityTemplate.script;
    }

    public abstract Entity createInstance();

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Scriptable getConversation() {
        return this.conversation;
    }

    public boolean hasScript() {
        return this.script != null;
    }

    public Scriptable getScript() {
        return this.script;
    }
}

