/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.ContainerTemplate;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Door;
import net.sf.hale.entity.DoorTemplate;
import net.sf.hale.entity.EntityTemplate;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.ItemTemplate;
import net.sf.hale.entity.NPC;
import net.sf.hale.entity.NPCTemplate;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.PCTemplate;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.rules.Quality;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class EntityManager {
    private static Map<String, EntityTemplate> templates = new HashMap<String, EntityTemplate>();
    private static Map<String, Creature> creatures = new HashMap<String, Creature>();

    public static void addLoadedPC(PC pC) {
        templates.put(pC.getTemplate().getID(), pC.getTemplate());
        creatures.put(pC.getTemplate().getID(), pC);
    }

    public static NPC getNPC(String string) {
        if (!creatures.containsKey(string)) {
            EntityManager.loadNPC(string);
        }
        NPC nPC = new NPC((NPC)creatures.get(string));
        nPC.resetTime();
        return nPC;
    }

    public static PC getPC(String string) {
        if (!creatures.containsKey(string)) {
            EntityManager.loadPC(string);
        }
        PC pC = new PC((PC)creatures.get(string));
        pC.resetTime();
        return pC;
    }

    private static void loadNPC(String string) {
        String string2 = "creatures/" + string;
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser(string2, ResourceType.JSON);
        NPCTemplate nPCTemplate = new NPCTemplate(string, simpleJSONParser.getObject());
        templates.put(string, nPCTemplate);
        NPC nPC = new NPC(nPCTemplate, simpleJSONParser);
        creatures.put(string, nPC);
    }

    private static void loadPC(String string) {
        Object object;
        SimpleJSONParser simpleJSONParser;
        String string2 = "creatures/" + string;
        if (ResourceManager.hasResource(string2 + ResourceType.JSON.getExtension())) {
            simpleJSONParser = new SimpleJSONParser(string2, ResourceType.JSON);
        } else {
            object = string + ResourceType.JSON.getExtension();
            if (new File("characters/" + (String)object).isFile()) {
                simpleJSONParser = new SimpleJSONParser(new File("characters/" + (String)object));
            } else if (new File(Game.getCharactersBaseDirectory() + (String)object).isFile()) {
                simpleJSONParser = new SimpleJSONParser(new File(Game.getCharactersBaseDirectory() + (String)object));
            } else {
                throw new IllegalArgumentException("Unable to locate PC " + string);
            }
        }
        object = new PCTemplate(string, simpleJSONParser.getObject());
        templates.put(string, (EntityTemplate)object);
        try {
            PC pC = new PC((PCTemplate)object, simpleJSONParser);
            creatures.put(string, pC);
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error loading PC " + string, exception);
        }
    }

    public static Item getItem(String string) {
        ItemTemplate itemTemplate = EntityManager.getItemTemplate(string);
        if (itemTemplate == null) {
            return null;
        }
        Item item = itemTemplate.createInstance();
        Quality quality = itemTemplate.getDefaultQuality();
        if (quality == null) {
            item.setQuality(null);
        } else {
            item.setQuality(quality.getName());
        }
        return item;
    }

    public static Item getItem(String string, String string2) {
        Item item = EntityManager.getItemTemplate(string).createInstance();
        item.setQuality(string2);
        return item;
    }

    public static boolean hasEntityTemplate(String string) {
        return templates.containsKey(string);
    }

    public static Item getItem(String string, Quality quality) {
        Item item = EntityManager.getItemTemplate(string).createInstance();
        if (quality != null) {
            item.setQuality(quality.getName());
        } else {
            item.setQuality(null);
        }
        return item;
    }

    public static Container getContainer(String string) {
        return EntityManager.getContainerTemplate(string).createInstance();
    }

    public static Door getDoor(String string) {
        return EntityManager.getDoorTemplate(string).createInstance();
    }

    public static Container getTemporaryContainer() {
        return EntityManager.getContainer(Game.ruleset.getString("TemporaryContainerID"));
    }

    public static ItemTemplate getItemTemplate(String string) {
        if (templates.containsKey(string)) {
            return (ItemTemplate)templates.get(string);
        }
        if (ResourceManager.hasResource("items/" + string + ResourceType.JSON.getExtension())) {
            String string2 = "items/" + string;
            SimpleJSONParser simpleJSONParser = new SimpleJSONParser(string2, ResourceType.JSON);
            String string3 = simpleJSONParser.get("class", "Item");
            String string4 = string3 + "Template";
            try {
                Class<?> clazz = Class.forName(EntityManager.class.getPackage().getName() + "." + string4);
                Constructor<?> constructor = clazz.getConstructor(String.class, SimpleJSONObject.class);
                ItemTemplate itemTemplate = (ItemTemplate)constructor.newInstance(string, simpleJSONParser.getObject());
                templates.put(string, itemTemplate);
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error constructing item template " + string, exception);
            }
        } else if (Game.curCampaign.getCreatedItem(string) != null) {
            CreatedItem createdItem = Game.curCampaign.getCreatedItem(string);
            templates.put(string, createdItem.getTemplate());
        } else {
            return null;
        }
        return (ItemTemplate)templates.get(string);
    }

    public static ContainerTemplate getContainerTemplate(String string) {
        if (templates.containsKey(string)) {
            return (ContainerTemplate)templates.get(string);
        }
        String string2 = "items/" + string;
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser(string2, ResourceType.JSON);
        ContainerTemplate containerTemplate = new ContainerTemplate(string, simpleJSONParser.getObject());
        templates.put(string, containerTemplate);
        return containerTemplate;
    }

    public static DoorTemplate getDoorTemplate(String string) {
        if (templates.containsKey(string)) {
            return (DoorTemplate)templates.get(string);
        }
        String string2 = "items/" + string;
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser(string2, ResourceType.JSON);
        DoorTemplate doorTemplate = new DoorTemplate(string, simpleJSONParser.getObject());
        templates.put(string, doorTemplate);
        return doorTemplate;
    }

    public static NPCTemplate getNPCTemplate(String string) {
        if (!templates.containsKey(string)) {
            EntityManager.loadNPC(string);
        }
        return (NPCTemplate)templates.get(string);
    }

    public static PCTemplate getPCTemplate(String string) {
        if (!templates.containsKey(string)) {
            EntityManager.loadPC(string);
        }
        return (PCTemplate)templates.get(string);
    }

    public static void clear() {
        templates.clear();
        creatures.clear();
    }
}

