/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.HasScriptState;
import net.sf.hale.ScriptState;
import net.sf.hale.ability.Aura;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.EffectTarget;
import net.sf.hale.ability.EntityEffectSet;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.area.Area;
import net.sf.hale.entity.EntityListener;
import net.sf.hale.entity.EntityTemplate;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.loading.Saveable;
import net.sf.hale.rules.Faction;
import net.sf.hale.util.Point;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.view.ConversationPopup;

public abstract class Entity
implements EffectTarget,
Saveable,
HasScriptState,
Comparable<Entity> {
    private final EntityTemplate template;
    private String faction;
    private Location location;
    private final ScriptState scriptState;
    private final EntityEffectSet effects;
    private List<EntityListener> viewers;

    protected Entity(EntityTemplate entityTemplate) {
        if (entityTemplate == null) {
            throw new NullPointerException("entity template must not be null");
        }
        this.template = entityTemplate;
        this.scriptState = new ScriptState();
        this.effects = new EntityEffectSet();
        this.faction = Game.ruleset.getString("DefaultFaction");
        this.location = Location.Inventory;
        this.viewers = new ArrayList<EntityListener>();
    }

    protected Entity(Entity entity) {
        this.template = entity.template;
        this.scriptState = new ScriptState(entity.scriptState);
        this.effects = new EntityEffectSet(entity.effects, this);
        this.faction = entity.faction;
        this.location = Location.Inventory;
        this.viewers = new ArrayList<EntityListener>();
    }

    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        this.faction = simpleJSONObject.get("faction", null);
        referenceHandler.add(simpleJSONObject.get("ref", null), this);
        this.location = simpleJSONObject.containsKey("location") ? Location.load(simpleJSONObject.getObject("location"), area) : Location.Inventory;
        if (simpleJSONObject.containsKey("scriptState")) {
            this.scriptState.load(simpleJSONObject.getObject("scriptState"));
        }
        if (simpleJSONObject.containsKey("effects")) {
            this.effects.load(simpleJSONObject.getObject("effects"), referenceHandler, this);
        }
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("id", this.template.getID());
        jSONOrderedObject.put("class", this.getClass().getSimpleName());
        jSONOrderedObject.put("ref", SaveGameUtil.getRef(this));
        jSONOrderedObject.put("faction", this.faction);
        if (this.location.getArea() != null) {
            jSONOrderedObject.put("location", this.location.save());
        }
        if (!this.scriptState.isEmpty()) {
            jSONOrderedObject.put("scriptState", this.scriptState.save());
        }
        if (this.effects.size() > 0) {
            jSONOrderedObject.put("effects", this.effects.save());
        }
        return jSONOrderedObject;
    }

    public void addViewer(EntityListener entityListener) {
        this.viewers.add(entityListener);
    }

    public void removeViewer(EntityListener entityListener) {
        this.viewers.remove(entityListener);
    }

    public void updateListeners() {
        for (EntityListener entityListener : this.viewers) {
            entityListener.entityUpdated(this);
        }
    }

    public void removeAllListeners() {
        for (EntityListener entityListener : this.viewers) {
            entityListener.removeListener();
        }
        this.viewers.clear();
    }

    @Override
    public int getSpellResistance() {
        return 0;
    }

    @Override
    public boolean isValidEffectTarget() {
        return true;
    }

    @Override
    public Object get(String string) {
        return this.scriptState.get(string);
    }

    @Override
    public void put(String string, Object object) {
        this.scriptState.put(string, object);
    }

    public EntityTemplate getTemplate() {
        return this.template;
    }

    public Faction getFaction() {
        return Game.ruleset.getFaction(this.faction);
    }

    public Location getLocation() {
        return this.location;
    }

    public EntityEffectSet getEffects() {
        return this.effects;
    }

    public String getName() {
        return this.template.getName();
    }

    public boolean setLocationInCurrentArea(int n, int n2) {
        try {
            Area area = this.location.getArea();
            if (area == null) {
                area = Game.curCampaign.curArea;
            }
            return this.setLocation(new Location(area, n, n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean setLocation(Area area, int n, int n2) {
        return this.setLocation(new Location(area, n, n2));
    }

    public boolean setLocation(Location location) {
        Location location2 = this.location;
        Point point = this.location.getScreenPoint();
        Point point2 = location.getScreenPoint();
        this.location = location;
        this.effects.offsetAnimationPositions(point2.x - point.x, point2.y - point.y);
        this.effects.moveAuras();
        if (location2 != null && location2.getArea() != null) {
            if (location2.getArea() == location.getArea()) {
                this.location.getArea().getEntities().moveEntity(this, location2);
            } else {
                location2.getArea().getEntities().removeEntity(this);
                location.getArea().getEntities().addEntity(this);
            }
        }
        return true;
    }

    public void setFaction(Faction faction) {
        this.faction = faction.getName();
    }

    public void setFaction(String string) {
        this.setFaction(Game.ruleset.getFaction(string));
    }

    public boolean isPlayerFaction() {
        return this.faction.equals(Game.ruleset.getString("PlayerFaction"));
    }

    public void uiDraw(int n, int n2) {
        this.template.getIcon().draw(n, n2);
    }

    public void areaDraw(int n, int n2) {
        this.template.getIcon().drawCentered(n, n2, 72, 72);
    }

    public boolean elapseTime(int n) {
        this.effects.elapseRounds(this, n);
        return false;
    }

    public void startConversation(PC pC) {
        ConversationPopup conversationPopup = new ConversationPopup(this, pC, this.template.getConversation());
        conversationPopup.startConversation();
    }

    public Effect createEffect() {
        return new Effect();
    }

    public Effect createEffect(String string) {
        return new Effect(string);
    }

    public Aura createAura(String string) {
        return new Aura(string);
    }

    public void applyEffect(Effect effect) {
        effect.setTarget(this);
        effect.executeFunction(ScriptFunctionType.onApply, effect);
        this.applyEffectBonuses(effect);
        effect.startAnimations();
        this.effects.add(effect, this.getLocation().getArea() != null);
        this.updateListeners();
    }

    @Override
    public void removeEffect(Effect effect) {
        if (effect == null) {
            return;
        }
        effect.executeFunction(ScriptFunctionType.onRemove, effect);
        this.removeEffectBonuses(effect);
        effect.endAnimations();
        this.effects.remove(effect);
        this.updateListeners();
    }

    protected void applyEffectBonuses(Effect effect) {
    }

    protected void removeEffectBonuses(Effect effect) {
    }

    @Override
    public int compareTo(Entity entity) {
        return this.hashCode() - entity.hashCode();
    }
}

