/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.ScriptInterface;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.NPC;
import net.sf.hale.rules.Faction;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import net.sf.hale.util.PointImmutable;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class EncounterTemplate {
    private final String id;
    private final List<Entry> creatures;
    private final int minRandomCreatures;
    private final int maxRandomCreatures;
    private final int respawnTimeInHours;
    private final int challengeRating;
    private final int radius;
    private final Faction faction;

    public EncounterTemplate(String string, SimpleJSONParser simpleJSONParser) {
        this.id = string;
        this.respawnTimeInHours = simpleJSONParser.containsKey("respawnTime") ? simpleJSONParser.get("respawnTime", 0) : -1;
        this.radius = simpleJSONParser.get("radius", 0);
        String string2 = simpleJSONParser.get("faction", null);
        this.faction = Game.ruleset.getFaction(string2);
        if (simpleJSONParser.containsKey("minRandomCreatures")) {
            this.minRandomCreatures = simpleJSONParser.get("minRandomCreatures", 0);
            this.maxRandomCreatures = simpleJSONParser.get("maxRandomCreatures", 0);
        } else {
            this.minRandomCreatures = -1;
            this.maxRandomCreatures = -1;
        }
        this.creatures = new ArrayList<Entry>();
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONParser.getArray("creatures")) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            String string3 = simpleJSONObject.get("id", null);
            int n = 0;
            int n2 = 0;
            if (simpleJSONObject.containsKey("x")) {
                n = simpleJSONObject.get("x", 0);
                n2 = simpleJSONObject.get("y", 0);
            }
            this.creatures.add(new Entry(string3, n, n2));
        }
        this.challengeRating = simpleJSONParser.containsKey("challengeRating") ? simpleJSONParser.get("challengeRating", 0) : -1;
    }

    public String getID() {
        return this.id;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean randomizesCreatures() {
        return this.minRandomCreatures != -1;
    }

    public int getMinRandomCreatures() {
        return this.minRandomCreatures;
    }

    public int getMaxRandomCreatures() {
        return this.maxRandomCreatures;
    }

    public boolean respawns() {
        return this.respawnTimeInHours != -1;
    }

    public int getRespawnTimeInHours() {
        return this.respawnTimeInHours;
    }

    public int getChallengeRating() {
        return this.challengeRating;
    }

    public Faction getDefaultFaction() {
        return this.faction;
    }

    public Map<PointImmutable, NPC> spawnCreatures(Location location) {
        HashMap<PointImmutable, NPC> hashMap = new HashMap<PointImmutable, NPC>();
        if (this.randomizesCreatures() && ScriptInterface.SpawnRandomEncounters) {
            int n = Game.dice.rand(this.minRandomCreatures, this.maxRandomCreatures);
            for (int i = 0; i < n; ++i) {
                Entry entry = this.creatures.get(Game.dice.rand(0, this.creatures.size() - 1));
                hashMap.put(this.getFreeRandomLocation(hashMap, location), EntityManager.getNPC(entry.creatureID));
            }
        } else {
            for (Entry entry : this.creatures) {
                int n = location.getX() + ((Entry)entry).position.x;
                int n2 = location.getY() + ((Entry)entry).position.y;
                if (((Entry)entry).position.x % 2 != 0 && location.getX() % 2 != 0) {
                    ++n2;
                }
                hashMap.put(new PointImmutable(n, n2), EntityManager.getNPC(entry.creatureID));
            }
        }
        return hashMap;
    }

    private PointImmutable getFreeRandomLocation(Map<PointImmutable, NPC> map, Location location) {
        for (int i = 0; i < 100; ++i) {
            int n = Game.dice.rand(0, this.radius);
            int n2 = Game.dice.rand(0, n * 6);
            Point point = AreaUtil.convertPolarToGrid(location.toPoint(), n, n2);
            if (!location.getArea().isFreeForCreature(point.x, point.y)) continue;
            boolean bl = true;
            for (PointImmutable pointImmutable : map.keySet()) {
                if (pointImmutable.x != point.x || pointImmutable.y != point.y) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return new PointImmutable(point.x, point.y);
        }
        return null;
    }

    private class Entry {
        private final String creatureID;
        private final PointImmutable position;

        private Entry(String string, int n, int n2) {
            this.creatureID = string;
            this.position = new PointImmutable(n, n2);
        }
    }
}

