/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.ScriptInterface;
import net.sf.hale.area.Area;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EncounterTemplate;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.NPC;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.rules.Currency;
import net.sf.hale.rules.Faction;
import net.sf.hale.rules.XP;
import net.sf.hale.util.Logger;
import net.sf.hale.util.PointImmutable;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class Encounter
implements Iterable<Creature> {
    private final EncounterTemplate template;
    private Faction faction;
    private final Location location;
    private int lastSpawnRound;
    private List<Creature> creaturesInArea;
    private boolean aiActive;
    private List<Creature> knownHostiles;
    private int currencyToReward;
    private int xpToReward;

    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("name", this.template.getID());
        jSONOrderedObject.put("x", this.location.getX());
        jSONOrderedObject.put("y", this.location.getY());
        jSONOrderedObject.put("lastSpawnTime", this.lastSpawnRound);
        jSONOrderedObject.put("faction", this.faction.getName());
        if (this.currencyToReward != 0) {
            jSONOrderedObject.put("currencyToReward", this.currencyToReward);
        }
        if (this.xpToReward != 0) {
            jSONOrderedObject.put("xpToReward", this.xpToReward);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Creature creature : this.creaturesInArea) {
            arrayList.add(SaveGameUtil.getRef(creature));
        }
        if (!arrayList.isEmpty()) {
            jSONOrderedObject.put("creatures", arrayList.toArray());
        }
        return jSONOrderedObject;
    }

    public static Encounter load(SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler, Area area) {
        String string = simpleJSONObject.get("name", null);
        int n = simpleJSONObject.get("x", 0);
        int n2 = simpleJSONObject.get("y", 0);
        Encounter encounter = Game.curCampaign.getEncounter(string, new Location(area, n, n2));
        encounter.lastSpawnRound = simpleJSONObject.get("lastSpawnTime", 0);
        encounter.faction = Game.ruleset.getFaction(simpleJSONObject.get("faction", null));
        if (simpleJSONObject.containsKey("creatures")) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("creatures")) {
                String string2 = simpleJSONArrayEntry.getString();
                Creature creature = (Creature)referenceHandler.getEntity(string2);
                if (creature == null) {
                    Logger.appendToWarningLog("Error resolving reference for creature " + string2 + " when loading encounter");
                    continue;
                }
                creature.setEncounter(encounter);
                creature.setFaction(encounter.faction);
                encounter.creaturesInArea.add(creature);
            }
        }
        encounter.currencyToReward = simpleJSONObject.containsKey("currencyToReward") ? simpleJSONObject.get("currencyToReward", 0) : 0;
        encounter.xpToReward = simpleJSONObject.containsKey("xpToReward") ? simpleJSONObject.get("xpToReward", 0) : 0;
        return encounter;
    }

    public Encounter(EncounterTemplate encounterTemplate, Location location) {
        this.template = encounterTemplate;
        this.location = location;
        this.lastSpawnRound = -1;
        this.creaturesInArea = new ArrayList<Creature>();
        this.faction = encounterTemplate.getDefaultFaction();
        this.aiActive = false;
        this.knownHostiles = new ArrayList<Creature>();
    }

    public void setAIActive(boolean bl) {
        this.aiActive = bl;
    }

    public boolean isAIActive() {
        return this.aiActive;
    }

    public void checkAddHostile(Creature creature) {
        for (Creature creature2 : this.knownHostiles) {
            if (creature2 != creature) continue;
            return;
        }
        this.knownHostiles.add(creature);
    }

    public void addHostile(Creature creature) {
        this.checkAddHostile(creature);
    }

    public void addHostiles(List<Creature> list) {
        for (Creature creature : list) {
            this.checkAddHostile(creature);
        }
    }

    public List<Creature> getHostiles() {
        return new ArrayList<Creature>(this.knownHostiles);
    }

    public void removeAllHostiles() {
        this.knownHostiles.clear();
    }

    public void setFaction(String string) {
        this.setFaction(Game.ruleset.getFaction(string));
    }

    public void setFaction(Faction faction) {
        this.faction = faction;
        for (Creature creature : this.creaturesInArea) {
            creature.setFaction(faction);
        }
        Game.areaListener.getCombatRunner().checkAIActivation();
    }

    public EncounterTemplate getTemplate() {
        return this.template;
    }

    public Faction getFaction() {
        return this.faction;
    }

    public Location getLocation() {
        return this.location;
    }

    public List<Creature> getCreaturesInArea() {
        return this.creaturesInArea;
    }

    public void removeCreatureFromArea(Creature creature) {
        this.creaturesInArea.remove(creature);
    }

    public boolean checkSpawnCreatures() {
        if (this.lastSpawnRound == -1) {
            this.spawnCreatures();
            return true;
        }
        int n = Game.curCampaign.getDate().getTotalRoundsElapsed() - this.lastSpawnRound;
        if (this.template.respawns() && n > this.template.getRespawnTimeInHours() * Game.curCampaign.getDate().ROUNDS_PER_HOUR) {
            this.spawnCreatures();
            return true;
        }
        return false;
    }

    public void checkAwardXP(int n) {
        for (Creature creature : this.creaturesInArea) {
            if (creature.isDead()) continue;
            return;
        }
        if (this.currencyToReward != 0) {
            Game.curCampaign.partyCurrency.addValue(this.currencyToReward);
            Game.mainViewer.addMessage("green", "The party gained " + Currency.shortString(this.currencyToReward, 100) + ".");
            this.currencyToReward = 0;
        }
        if (this.xpToReward != 0) {
            int n2 = 10000 + Math.min(Game.ruleset.getValue("CombatLengthXPFactor") * n, Game.ruleset.getValue("CombatLengthXPMax"));
            this.xpToReward = this.xpToReward * n2 / 10000;
            XP.addPartyXP(this.xpToReward);
            this.xpToReward = 0;
        }
        this.knownHostiles.clear();
        this.aiActive = false;
    }

    private void spawnCreatures() {
        this.currencyToReward = 0;
        Area area = this.location.getArea();
        this.lastSpawnRound = Game.curCampaign.getDate().getTotalRoundsElapsed();
        for (int i = this.creaturesInArea.size() - 1; i >= 0; --i) {
            area.removeEntity(this.creaturesInArea.get(i));
        }
        this.creaturesInArea.clear();
        this.aiActive = false;
        this.knownHostiles.clear();
        if (this.template.randomizesCreatures() && ScriptInterface.SpawnRandomEncounters || !this.template.randomizesCreatures()) {
            Map<PointImmutable, NPC> map = this.template.spawnCreatures(this.location);
            for (PointImmutable object : map.keySet()) {
                Creature creature = map.get(object);
                creature.setEncounter(this);
                creature.setLocation(new Location(area, object.x, object.y));
                creature.setFaction(this.faction);
                area.getEntities().addEntity(creature);
                this.creaturesInArea.add(creature);
                this.currencyToReward += ((NPC)creature).getTemplate().generateReward();
            }
        }
        if (this.template.getChallengeRating() != -1) {
            double d = (double)this.template.getChallengeRating() / (double)Game.ruleset.getValue("EncounterChallengeFactor");
            this.xpToReward = (int)(d * (double)Game.ruleset.getValue("EncounterXPFactor"));
        } else {
            double d = 0.0;
            for (Creature creature : this.creaturesInArea) {
                d += (double)((float)creature.roles.getTotalLevel() / (float)this.creaturesInArea.size());
            }
            double d2 = (double)Game.ruleset.getValue("EncounterGroupChallengeScaleFactor") / 1000.0;
            double d3 = Math.log(this.creaturesInArea.size() + 1) * d2 * d;
            this.xpToReward = (int)(d3 * (double)Game.ruleset.getValue("EncounterXPFactor"));
        }
    }

    @Override
    public Iterator<Creature> iterator() {
        return this.creaturesInArea.iterator();
    }
}

