/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.Game;
import net.sf.hale.area.Area;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.DoorTemplate;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.Openable;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.util.SimpleJSONObject;

public class Door
extends Openable {
    private final DoorTemplate template;

    @Override
    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        super.load(simpleJSONObject, area, referenceHandler);
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        return jSONOrderedObject;
    }

    protected Door(DoorTemplate doorTemplate) {
        super(doorTemplate);
        this.template = doorTemplate;
    }

    public boolean isTransparent() {
        return this.isOpen() || this.template.isTransparent();
    }

    @Override
    public DoorTemplate getTemplate() {
        return this.template;
    }

    @Override
    public boolean attemptOpen(Creature creature) {
        boolean bl = super.attemptOpen(creature);
        this.getLocation().getArea().getTransparency()[this.getLocation().getX()][this.getLocation().getY()] = this.isOpen();
        creature.getLocation().getArea().getUtil().updateVisibility();
        if (bl) {
            Game.areaListener.getCombatRunner().checkAIActivation();
        }
        return bl;
    }

    @Override
    public void close(Creature creature) {
        super.close(creature);
        this.getLocation().getArea().getTransparency()[this.getLocation().getX()][this.getLocation().getY()] = this.isOpen();
        creature.getLocation().getArea().getUtil().updateVisibility();
    }

    @Override
    public int compareTo(Entity entity) {
        if (entity instanceof Creature) {
            return -1;
        }
        if (entity instanceof Container) {
            return 1;
        }
        return super.compareTo(entity);
    }
}

