/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.Game;
import net.sf.hale.entity.EntityTemplate;
import net.sf.hale.icon.Icon;
import net.sf.hale.rules.Race;
import net.sf.hale.rules.Ruleset;
import net.sf.hale.util.SimpleJSONObject;

public abstract class CreatureTemplate
extends EntityTemplate {
    private final Ruleset.Gender gender;
    private final Race race;
    private final String portrait;
    private final int initiativeTickerHeight;

    public CreatureTemplate(String string, String string2, Icon icon, Ruleset.Gender gender, Race race, String string3) {
        super(string, string2, icon);
        this.gender = gender;
        this.race = race;
        this.portrait = string3;
        this.initiativeTickerHeight = 72;
    }

    public CreatureTemplate(String string, SimpleJSONObject simpleJSONObject) {
        super(string, simpleJSONObject);
        String string2 = simpleJSONObject.get("gender", null);
        this.gender = Ruleset.Gender.valueOf(string2);
        String string3 = simpleJSONObject.get("race", null);
        this.race = Game.ruleset.getRace(string3);
        this.portrait = simpleJSONObject.get("portrait", null);
        this.initiativeTickerHeight = simpleJSONObject.containsKey("initiativeTickerHeight") ? simpleJSONObject.get("initiativeTickerHeight", 0) : 72;
    }

    public int getInitiativeTickerHeight() {
        return this.initiativeTickerHeight;
    }

    public Ruleset.Gender getGender() {
        return this.gender;
    }

    public Race getRace() {
        return this.race;
    }

    public String getPortrait() {
        return this.portrait;
    }
}

