/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import de.matthiasmann.twl.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.CreatureAbilitySet;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.area.Area;
import net.sf.hale.bonus.Stat;
import net.sf.hale.bonus.StatManager;
import net.sf.hale.entity.Ammo;
import net.sf.hale.entity.CreatureTemplate;
import net.sf.hale.entity.Encounter;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.Path;
import net.sf.hale.entity.RoundTimer;
import net.sf.hale.entity.Trap;
import net.sf.hale.entity.Weapon;
import net.sf.hale.entity.WeaponTemplate;
import net.sf.hale.icon.ComposedCreatureIcon;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.icon.IconRenderer;
import net.sf.hale.icon.SimpleIcon;
import net.sf.hale.icon.SubIcon;
import net.sf.hale.icon.SubIconRenderer;
import net.sf.hale.interfacelock.EntityOffsetAnimation;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.rules.Attack;
import net.sf.hale.rules.Damage;
import net.sf.hale.rules.RoleSet;
import net.sf.hale.rules.SkillSet;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public abstract class Creature
extends Entity {
    private final CreatureTemplate template;
    private final IconRenderer renderer;
    private Point animatingOffset;
    private EntityOffsetAnimation offsetAnimation;
    private Encounter encounter;
    private boolean[][] visibility;
    private int currentHitPoints;
    private int temporaryHitPoints;
    private int summonExpiration;
    private int attacksOfOpportunityAvailable;
    private volatile boolean isCurrentlyMoving;
    private boolean alreadySearchedForHiddenCreatures;
    private final List<Creature> moveAoOsThisRound;
    public final StatManager stats;
    public final Inventory inventory;
    public final RoleSet roles;
    public final SkillSet skills;
    public final CreatureAbilitySet abilities;
    public final RoundTimer timer;

    @Override
    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        super.load(simpleJSONObject, area, referenceHandler);
        this.currentHitPoints = simpleJSONObject.get("currentHitPoints", 0);
        this.temporaryHitPoints = simpleJSONObject.containsKey("temporaryHitPoints") ? simpleJSONObject.get("temporaryHitPoints", 0) : 0;
        this.summonExpiration = simpleJSONObject.containsKey("summonExpiration") ? simpleJSONObject.get("summonExpiration", 0) : -1;
        this.skills.load(simpleJSONObject.getObject("skills"));
        this.roles.load(simpleJSONObject.getObject("roles"), false);
        this.abilities.load(simpleJSONObject.getObject("abilities"), referenceHandler);
        this.inventory.load(simpleJSONObject.getObject("inventory"), referenceHandler);
        this.stats.recomputeAllStats();
        this.timer.reset();
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("currentHitPoints", this.currentHitPoints);
        if (this.temporaryHitPoints > 0) {
            jSONOrderedObject.put("temporaryHitPoints", this.temporaryHitPoints);
        }
        if (this.summonExpiration > 0) {
            jSONOrderedObject.put("summonExpiration", this.summonExpiration);
        }
        jSONOrderedObject.put("inventory", this.inventory.save());
        jSONOrderedObject.put("roles", this.roles.save());
        jSONOrderedObject.put("skills", this.skills.save());
        jSONOrderedObject.put("abilities", this.abilities.save());
        return jSONOrderedObject;
    }

    protected Creature(CreatureTemplate creatureTemplate, SimpleJSONParser simpleJSONParser) {
        super(creatureTemplate);
        this.template = creatureTemplate;
        this.renderer = this.createIconRenderer();
        this.stats = new StatManager(this);
        SimpleJSONObject simpleJSONObject = simpleJSONParser.getObject("attributes");
        int[] nArray = new int[]{simpleJSONObject.get("strength", 0), simpleJSONObject.get("dexterity", 0), simpleJSONObject.get("constitution", 0), simpleJSONObject.get("intelligence", 0), simpleJSONObject.get("wisdom", 0), simpleJSONObject.get("charisma", 0)};
        this.stats.setAttributes(nArray);
        this.skills = new SkillSet(this);
        if (simpleJSONParser.containsKey("skills")) {
            this.skills.load(simpleJSONParser.getObject("skills"));
        }
        this.abilities = new CreatureAbilitySet(this);
        if (simpleJSONParser.containsKey("abilities")) {
            SimpleJSONArray simpleJSONArray = simpleJSONParser.getArray("abilities");
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
                simpleJSONObject = simpleJSONArrayEntry.getObject();
                String string = simpleJSONObject.get("id", null);
                int n = simpleJSONObject.get("levelObtained", 0);
                try {
                    this.abilities.add(Game.ruleset.getAbility(string), n);
                }
                catch (Exception exception) {
                    Logger.appendToErrorLog("Error loading ability " + string, exception);
                }
            }
        }
        this.roles = new RoleSet(this);
        this.roles.load(simpleJSONParser.getObject("roles"), true);
        this.timer = new RoundTimer(this);
        this.summonExpiration = -1;
        this.moveAoOsThisRound = new ArrayList<Creature>(2);
        this.animatingOffset = new Point();
        this.currentHitPoints = 1;
        this.inventory = new Inventory(this);
        try {
            this.inventory.load(simpleJSONParser.getObject("inventory"), null);
        }
        catch (LoadGameException loadGameException) {
            Logger.appendToErrorLog("Error loading inventory for " + creatureTemplate.getID(), loadGameException);
        }
    }

    protected Creature(CreatureTemplate creatureTemplate) {
        super(creatureTemplate);
        this.template = creatureTemplate;
        this.renderer = creatureTemplate.getRace() != null && creatureTemplate.getGender() != null ? this.createIconRenderer() : IconFactory.emptyIcon;
        this.stats = new StatManager(this);
        this.roles = new RoleSet(this);
        this.skills = new SkillSet(this);
        this.abilities = new CreatureAbilitySet(this);
        this.timer = new RoundTimer(this);
        this.summonExpiration = -1;
        this.moveAoOsThisRound = new ArrayList<Creature>(2);
        this.animatingOffset = new Point();
        this.currentHitPoints = 1;
        this.inventory = new Inventory(this);
    }

    protected Creature(Creature creature) {
        super(creature);
        this.template = creature.template;
        this.renderer = this.createIconRenderer();
        this.stats = new StatManager(creature.stats, this);
        this.roles = new RoleSet(creature.roles, this);
        this.skills = new SkillSet(creature.skills, this);
        this.abilities = new CreatureAbilitySet(creature.abilities, this);
        this.timer = new RoundTimer(this);
        this.summonExpiration = -1;
        this.moveAoOsThisRound = new ArrayList<Creature>(2);
        this.animatingOffset = new Point();
        this.currentHitPoints = 1;
        this.inventory = new Inventory(creature.inventory, this);
    }

    private IconRenderer createIconRenderer() {
        Icon icon = this.template.getIcon();
        if (icon instanceof ComposedCreatureIcon) {
            return new SubIconRenderer((ComposedCreatureIcon)icon, this.template.getRace(), this.template.getGender());
        }
        return icon;
    }

    public void setOffsetAnimation(EntityOffsetAnimation entityOffsetAnimation) {
        if (this.offsetAnimation != null) {
            this.offsetAnimation.cancel();
        }
        this.offsetAnimation = entityOffsetAnimation;
        if (this.offsetAnimation != null) {
            this.offsetAnimation.setAnimatingPoint(this.animatingOffset);
        }
    }

    public void setCurrentlyMoving(boolean bl) {
        this.isCurrentlyMoving = bl;
    }

    public boolean isCurrentlyMoving() {
        return this.isCurrentlyMoving;
    }

    public void setOffsetPoint(int n, int n2) {
        this.animatingOffset.x = n;
        this.animatingOffset.y = n2;
    }

    public int getAnimatingOffsetX() {
        return this.animatingOffset.x;
    }

    public int getAnimatingOffsetY() {
        return this.animatingOffset.y;
    }

    @Override
    public CreatureTemplate getTemplate() {
        return this.template;
    }

    public boolean isSummoned() {
        return this.summonExpiration != -1;
    }

    public void setSummoned(int n) {
        this.summonExpiration = Game.curCampaign.getDate().getTotalRoundsElapsed() + n;
    }

    public int getCurrentHitPoints() {
        return this.currentHitPoints + this.temporaryHitPoints;
    }

    public Encounter getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Encounter encounter) {
        this.encounter = encounter;
    }

    @Override
    public boolean setLocation(Location location) {
        Location location2 = this.getLocation();
        Point point = this.getLocation().getScreenPoint();
        Point point2 = location.getScreenPoint();
        super.setLocation(location);
        for (Inventory.Slot object2 : Inventory.Slot.values()) {
            if (this.inventory.getEquippedItem(object2) == null) continue;
            this.inventory.getEquippedItem(object2).getEffects().offsetAnimationPositions(point2.x - point.x, point2.y - point.y);
        }
        List<Object> list = location2.getArea() == null ? Collections.emptyList() : location2.getEffects();
        List<Object> list2 = location.getArea() == null ? Collections.emptyList() : location.getEffects();
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Effect effect = (Effect)iterator.next();
            if (effect.getTarget() == this || list2.contains(effect)) continue;
            effect.executeFunction(ScriptFunctionType.onTargetExit, this, effect);
        }
        for (Effect effect : list2) {
            if (effect.getTarget() == this || list.contains(effect)) continue;
            effect.executeFunction(ScriptFunctionType.onTargetEnter, this, effect);
        }
        this.computeVisibility();
        boolean bl = false;
        Trap trap = location.getTrap();
        if (trap != null && trap.checkSpringTrap(this)) {
            bl = true;
        }
        if (this.isPlayerFaction()) {
            location.getArea().checkPlayerMoved(this);
            for (Entity entity : location.getArea().getEntities()) {
                if (!(entity instanceof Trap) || !this.hasVisibilityInCurrentArea(entity.getLocation().getX(), entity.getLocation().getY()) || !((Trap)entity).attemptSearch(this)) continue;
                bl = true;
            }
        }
        this.setOffsetPoint(0, 0);
        return bl;
    }

    public void searchForHidingCreatures() {
        if (this.alreadySearchedForHiddenCreatures) {
            return;
        }
        this.alreadySearchedForHiddenCreatures = true;
        for (Creature creature : this.getVisibleCreatures()) {
            if (!creature.stats.isHidden() || !creature.getFaction().isHostile(this)) continue;
            this.performSearchCheck(creature, 0);
        }
    }

    public boolean performSearchCheck(Creature creature, int n) {
        int n2 = Game.ruleset.getValue("SearchCheckCreatureBaseDifficulty");
        int n3 = Game.ruleset.getValue("SearchCheckDistanceMultiplier");
        int n4 = n3 * this.getLocation().getDistance(creature.getLocation()) + n2;
        int n5 = Math.min(100, Game.curCampaign.curArea.getConcealment(this, creature));
        int n6 = creature.skills.getTotalModifier("Hide") + n4 + n5 - n;
        int n7 = this.skills.getCheck("Search", n6);
        if (n7 >= n6) {
            for (AbilitySlot abilitySlot : creature.abilities.getSlotsWithReadiedAbility("Hide")) {
                abilitySlot.deactivate();
            }
            Game.areaListener.getCombatRunner().checkAIActivation();
            return true;
        }
        return false;
    }

    public boolean isAIActive() {
        if (this.isPlayerFaction() && this.isSummoned()) {
            return true;
        }
        if (this.encounter == null) {
            return false;
        }
        return this.encounter.isAIActive();
    }

    public final boolean hasVisibilityInCurrentArea(int n, int n2) {
        return this.visibility[n][n2];
    }

    public final boolean hasVisibility(Location location) {
        if (location.getArea() != this.getLocation().getArea()) {
            return false;
        }
        return this.visibility[location.getX()][location.getY()];
    }

    public void computeVisibility() {
        Location location = this.getLocation();
        int n = location.getArea().getWidth();
        int n2 = location.getArea().getHeight();
        if (this.visibility == null || this.visibility.length != n || this.visibility[0].length != n2) {
            this.visibility = new boolean[n][n2];
        }
        location.getArea().getUtil().setVisibilityWithRespectToPosition(this.visibility, location.getX(), location.getY());
    }

    public void addVisibilityToMatrix(boolean[][] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            for (int j = 0; j < blArray[i].length; ++j) {
                blArray[i][j] = this.visibility[i][j] || blArray[i][j];
            }
        }
    }

    public boolean canTakeMoveAoOIgnoringLocation(Creature creature) {
        if (!this.getFaction().isHostile(creature)) {
            return false;
        }
        if (this.attacksOfOpportunityAvailable < 1) {
            return false;
        }
        return !this.moveAoOsThisRound.contains(creature);
    }

    public void takeMoveAoO(Creature creature) {
        this.moveAoOsThisRound.add(creature);
    }

    public void takeAttackOfOpportunity() {
        --this.attacksOfOpportunityAvailable;
    }

    public Weapon getOffHandWeapon() {
        EquippableItem equippableItem = this.inventory.getEquippedItem(Inventory.Slot.OffHand);
        if (equippableItem instanceof Weapon) {
            return (Weapon)equippableItem;
        }
        return null;
    }

    public Weapon getMainHandWeapon() {
        EquippableItem equippableItem = this.inventory.getEquippedItem(Inventory.Slot.MainHand);
        if (equippableItem == null) {
            return this.template.getRace().getDefaultWeapon();
        }
        return (Weapon)equippableItem;
    }

    public boolean threatensLocation(Location location) {
        if (location.getArea() != this.getLocation().getArea()) {
            return false;
        }
        return this.threatensPointInCurrentArea(location.getX(), location.getY());
    }

    public boolean threatensPointInCurrentArea(int n, int n2) {
        int n3;
        if (this.isDying() || this.isDead()) {
            return false;
        }
        if (this.attacksOfOpportunityAvailable < 1) {
            return false;
        }
        if (this.stats.isHelpless()) {
            return false;
        }
        if (!this.visibility[n][n2]) {
            return false;
        }
        Weapon weapon = this.getMainHandWeapon();
        if (!weapon.getTemplate().threatensAoOs()) {
            return false;
        }
        int n4 = this.getLocation().getX();
        int n5 = AreaUtil.distance(n4, n3 = this.getLocation().getY(), n, n2);
        return n5 <= weapon.getTemplate().getMaxRange() && n5 >= weapon.getTemplate().getMinRange();
    }

    public boolean canAttack(Location location) {
        Weapon weapon;
        if (!this.timer.canAttack()) {
            return false;
        }
        if (location.getArea() != this.getLocation().getArea()) {
            return false;
        }
        if (this.stats.isHelpless()) {
            return false;
        }
        if (!this.visibility[location.getX()][location.getY()]) {
            return false;
        }
        if (this.getLocation().getElevation() != location.getElevation()) {
            return false;
        }
        int n = location.getDistance(this);
        if (n > (weapon = this.getMainHandWeapon()).getTemplate().getMaxRange() || n < weapon.getTemplate().getMinRange()) {
            return false;
        }
        if (weapon.getTemplate().getWeaponType() == WeaponTemplate.Type.Ranged) {
            Ammo ammo = this.inventory.getEquippedQuiver();
            if (!weapon.getTemplate().isAmmoForThisWeapon(ammo)) {
                return false;
            }
        }
        return true;
    }

    public void addTemporaryHitPoints(int n) {
        if (this.isDead()) {
            return;
        }
        this.temporaryHitPoints += n;
        this.updateListeners();
    }

    public void removeTemporaryHitPoints(int n) {
        if (this.temporaryHitPoints > n) {
            this.takeDamage(n, "Effect");
        } else {
            this.takeDamage(this.temporaryHitPoints, "Effect");
        }
    }

    public void takeDamage(int n, String string) {
        Damage damage = new Damage(this, Game.ruleset.getDamageType(string), n);
        damage.computeAppliedDamage();
        this.takeDamage(damage);
    }

    public void takeDamage(Damage damage) {
        if (this.isDead()) {
            return;
        }
        this.getEffects().executeOnAll(ScriptFunctionType.onDamaged, damage);
        int n = damage.getTotalAppliedDamage();
        Game.mainViewer.addFadeAway(Integer.toString(n), this.getLocation().getX(), this.getLocation().getY(), new Color(-56832));
        if (this.temporaryHitPoints > n) {
            this.temporaryHitPoints -= n;
            n = 0;
        } else {
            n -= this.temporaryHitPoints;
            this.temporaryHitPoints = 0;
        }
        this.currentHitPoints -= n;
        Game.mainViewer.addMessage("red", damage.getMessage());
        if (this.isDead()) {
            Game.mainViewer.updateEntity(this);
        }
        this.updateListeners();
    }

    public void healDamage(int n) {
        if (this.isDead()) {
            return;
        }
        n = Math.max(0, Math.min(n, this.stats.getMaxHP() - this.currentHitPoints));
        this.currentHitPoints += n;
        Game.mainViewer.addMessage("blue", this.getTemplate().getName() + " was healed for " + n + " hit points.");
        Game.mainViewer.addFadeAway(Integer.toString(n), this.getLocation().getX(), this.getLocation().getY(), new Color(-13382401));
        this.updateListeners();
    }

    public void raiseFromDead() {
        if (!this.isDead()) {
            return;
        }
        this.temporaryHitPoints = 0;
        this.currentHitPoints = 1;
        Game.mainViewer.addFadeAway("Raised", this.getLocation().getX(), this.getLocation().getY(), new Color(-13382401));
        Game.mainViewer.addMessage("blue", this.getTemplate().getName() + " was raised.");
    }

    public boolean isDying() {
        return this.getCurrentHitPoints() < 1 && this.getCurrentHitPoints() > -20;
    }

    public boolean isDead() {
        if (!this.isPlayerFaction() || this.isSummoned()) {
            return this.getCurrentHitPoints() <= 0;
        }
        return this.getCurrentHitPoints() <= -20;
    }

    public Path findPathTo(Location location, int n) {
        return this.getLocation().getArea().getUtil().findShortestPath(this, location.toPoint(), n);
    }

    public Attack performMainHandAttack(Creature creature) {
        this.timer.performAttack();
        return new Attack(this, creature, Inventory.Slot.MainHand);
    }

    public Attack performOffHandAttack(Creature creature) {
        return new Attack(this, creature, Inventory.Slot.OffHand);
    }

    public Attack performSingleAttack(Creature creature, Inventory.Slot slot) {
        return new Attack(this, creature, slot);
    }

    @Override
    public void areaDraw(int n, int n2) {
        this.renderer.drawCentered(n + this.animatingOffset.x, n2 + this.animatingOffset.y, 72, 72);
    }

    @Override
    public void uiDraw(int n, int n2) {
        this.renderer.draw(n, n2);
    }

    public IconRenderer getIconRenderer() {
        return this.renderer;
    }

    public boolean drawsWithSubIcons() {
        return this.renderer instanceof SubIconRenderer;
    }

    public Point getSubIconScreenPosition(String string) {
        Point point = this.getLocation().getScreenPoint();
        SubIcon subIcon = ((SubIconRenderer)this.renderer).getSubIcon(string);
        Point point2 = subIcon.getOffset();
        point.x += point2.x + subIcon.getWidth() / 2;
        point.y += point2.y + subIcon.getHeight() / 2;
        return point;
    }

    protected void addSubIcon(EquippableItem equippableItem, Inventory.Slot slot) {
        if (!(this.renderer instanceof SubIconRenderer)) {
            return;
        }
        SimpleIcon simpleIcon = equippableItem.getTemplate().getSubIcon();
        if (simpleIcon == null) {
            return;
        }
        SubIcon.Type type = equippableItem.getTemplate().getSubIconTypeOverride();
        if (type == null) {
            type = slot.getSubIconType(equippableItem);
        }
        if (type == null) {
            return;
        }
        if (!this.template.getRace().drawsSubIconType(type)) {
            return;
        }
        SubIcon.Factory factory = new SubIcon.Factory(type, this.template.getRace(), this.template.getGender());
        factory.setPrimaryIcon(simpleIcon.getSpriteID(), simpleIcon.getColor());
        factory.setSecondaryIcon(null, ((ComposedCreatureIcon)this.template.getIcon()).getClothingColor());
        factory.setCoversBeard(equippableItem.getTemplate().coversBeard());
        factory.setCoversHair(equippableItem.getTemplate().coversHair());
        ((SubIconRenderer)this.renderer).add(factory.createSubIcon());
    }

    protected void removeSubIcon(EquippableItem equippableItem, Inventory.Slot slot) {
        if (!(this.renderer instanceof SubIconRenderer)) {
            return;
        }
        SubIcon.Type type = equippableItem.getTemplate().getSubIconTypeOverride();
        if (type == null) {
            type = slot.getSubIconType(equippableItem);
        }
        if (type == null) {
            return;
        }
        ((SubIconRenderer)this.renderer).remove(type);
    }

    @Override
    public boolean elapseTime(int n) {
        super.elapseTime(n);
        this.moveAoOsThisRound.clear();
        this.inventory.elapseTime(n);
        this.timer.reset();
        this.attacksOfOpportunityAvailable = this.stats.getAttacksOfOpportunity();
        if (this.isSummoned() && this.summonExpiration <= Game.curCampaign.getDate().getTotalRoundsElapsed()) {
            this.currentHitPoints = -20;
            this.temporaryHitPoints = 0;
            Game.mainViewer.updateEntity(this);
        }
        this.alreadySearchedForHiddenCreatures = false;
        boolean bl = this.abilities.elapseTime(n);
        this.updateListeners();
        return bl;
    }

    public void resetTime() {
        this.stats.recomputeAllStats();
        this.timer.reset();
        if (!this.isDead()) {
            this.temporaryHitPoints = 0;
            this.currentHitPoints = this.stats.get(Stat.MaxHP);
        }
        this.elapseTime(1);
    }

    public void endAllAnimations() {
        this.inventory.endAllAnimations();
        this.getEffects().endAllAnimations();
    }

    public List<Creature> getVisibleCreatures() {
        return this.getLocation().getArea().getEntities().getVisibleCreatures(this);
    }

    @Override
    protected void applyEffectBonuses(Effect effect) {
        if (this.inventory == null) {
            this.stats.addAllNoRecompute(effect.getBonuses());
        } else {
            this.stats.addAll(effect.getBonuses());
        }
    }

    @Override
    protected void removeEffectBonuses(Effect effect) {
        this.stats.removeAll(effect.getBonuses());
    }

    @Override
    public int compareTo(Entity entity) {
        if (entity instanceof Creature) {
            return super.compareTo(entity);
        }
        return 1;
    }
}

