/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.ArrayList;
import java.util.List;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.icon.ComposedIcon;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class CreatedItemModel
implements Saveable {
    private final String baseItemID;
    private final String createdItemID;
    private String namePrefix;
    private String namePostfix;
    private boolean forceNotUnequippable;
    private int valueModifier;
    private Icon overlayIcon;
    private final List<String> enchantments;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("baseItemID", this.baseItemID);
        jSONOrderedObject.put("createdItemID", this.createdItemID);
        if (!this.enchantments.isEmpty()) {
            jSONOrderedObject.put("scripts", this.enchantments.toArray());
        }
        if (this.namePrefix != null) {
            jSONOrderedObject.put("namePrefix", this.namePrefix);
        }
        if (this.namePostfix != null) {
            jSONOrderedObject.put("namePostfix", this.namePostfix);
        }
        if (this.forceNotUnequippable) {
            jSONOrderedObject.put("forceNotUnequippable", true);
        }
        if (this.valueModifier != 100) {
            jSONOrderedObject.put("valueModifier", this.valueModifier);
        }
        if (this.overlayIcon != IconFactory.emptyIcon) {
            jSONOrderedObject.put("overlayIcon", this.overlayIcon.save());
        }
        return jSONOrderedObject;
    }

    public static CreatedItemModel load(SimpleJSONObject simpleJSONObject) {
        CreatedItemModel createdItemModel = new CreatedItemModel(simpleJSONObject.get("baseItemID", null), simpleJSONObject.get("createdItemID", null));
        if (simpleJSONObject.containsKey("scripts")) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("scripts")) {
                createdItemModel.enchantments.add(simpleJSONArrayEntry.getString());
            }
        }
        if (simpleJSONObject.containsKey("namePrefix")) {
            createdItemModel.namePrefix = simpleJSONObject.get("namePrefix", null);
        }
        if (simpleJSONObject.containsKey("namePostfix")) {
            createdItemModel.namePostfix = simpleJSONObject.get("namePostfix", null);
        }
        if (simpleJSONObject.containsKey("forceNotUnequippable")) {
            createdItemModel.forceNotUnequippable = simpleJSONObject.get("forceNotUnequippable", false);
        }
        createdItemModel.valueModifier = simpleJSONObject.containsKey("valueModifier") ? simpleJSONObject.get("valueModifier", 100) : 100;
        createdItemModel.overlayIcon = simpleJSONObject.containsKey("overlayIcon") ? IconFactory.createIcon(simpleJSONObject.getObject("overlayIcon")) : IconFactory.emptyIcon;
        return createdItemModel;
    }

    public CreatedItemModel(String string, String string2) {
        this.baseItemID = string;
        this.createdItemID = string2;
        this.enchantments = new ArrayList<String>();
        this.overlayIcon = IconFactory.emptyIcon;
    }

    protected CreatedItemModel(CreatedItemModel createdItemModel) {
        this.baseItemID = createdItemModel.baseItemID;
        this.createdItemID = createdItemModel.createdItemID;
        this.enchantments = new ArrayList<String>(createdItemModel.enchantments);
        this.namePostfix = createdItemModel.namePostfix;
        this.namePrefix = createdItemModel.namePrefix;
        this.forceNotUnequippable = createdItemModel.forceNotUnequippable;
        this.valueModifier = createdItemModel.valueModifier;
        this.overlayIcon = createdItemModel.overlayIcon;
    }

    public void setOverlayIcon(Icon icon) {
        this.overlayIcon = icon;
    }

    public void setValueModifier(int n) {
        this.valueModifier = n;
    }

    public void setForceNotUnequippable(boolean bl) {
        this.forceNotUnequippable = bl;
    }

    public void setNamePrefix(String string) {
        this.namePrefix = string;
    }

    public void setNamePostfix(String string) {
        this.namePostfix = string;
    }

    public String getBaseItemID() {
        return this.baseItemID;
    }

    public String getCreatedItemID() {
        return this.createdItemID;
    }

    public void addEnchantment(String string) {
        this.enchantments.add(string);
    }

    public List<String> getEnchantments() {
        return this.enchantments;
    }

    public String getModifiedName(String string) {
        String string2 = this.namePrefix != null ? this.namePrefix + string : string;
        if (this.namePostfix != null) {
            string2 = string2 + this.namePostfix;
        }
        return string2;
    }

    public boolean getIsUnequippable(EquippableItemTemplate equippableItemTemplate) {
        if (this.forceNotUnequippable) {
            return false;
        }
        return equippableItemTemplate.isUnequippable();
    }

    public int getModifiedValue(int n) {
        return this.valueModifier * 100 + n * this.valueModifier / 100;
    }

    public Icon getModifiedIcon(Icon icon) {
        if (this.overlayIcon == IconFactory.emptyIcon) {
            return icon;
        }
        return new ComposedIcon(icon, this.overlayIcon);
    }

    public CreatedItem getCreatedItem() {
        return new CreatedItem(this);
    }
}

