/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import java.util.ArrayList;
import java.util.List;
import net.sf.hale.entity.CreatedItemModel;
import net.sf.hale.entity.Enchantment;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.icon.Icon;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.SimpleJSONObject;

public class CreatedItem
implements Saveable {
    private final CreatedItemModel model;
    private final EquippableItemTemplate template;

    @Override
    public Object save() {
        return this.model.save();
    }

    public static CreatedItem load(SimpleJSONObject simpleJSONObject) {
        CreatedItemModel createdItemModel = CreatedItemModel.load(simpleJSONObject);
        return new CreatedItem(createdItemModel);
    }

    public CreatedItem(CreatedItemModel createdItemModel) {
        this.model = new CreatedItemModel(createdItemModel);
        EquippableItemTemplate equippableItemTemplate = (EquippableItemTemplate)EntityManager.getItemTemplate(createdItemModel.getBaseItemID());
        this.template = equippableItemTemplate.createModifiedCopy(createdItemModel.getCreatedItemID(), this);
    }

    public EquippableItemTemplate getTemplate() {
        return this.template;
    }

    public String getBaseItemID() {
        return this.model.getBaseItemID();
    }

    public String getCreatedItemID() {
        return this.model.getCreatedItemID();
    }

    public List<Enchantment> getEnchantments() {
        ArrayList<Enchantment> arrayList = new ArrayList<Enchantment>();
        for (String string : this.model.getEnchantments()) {
            arrayList.add(new Enchantment(string, true));
        }
        return arrayList;
    }

    public String getModifiedName(String string) {
        return this.model.getModifiedName(string);
    }

    public boolean getIsUnequippable(EquippableItemTemplate equippableItemTemplate) {
        return this.model.getIsUnequippable(equippableItemTemplate);
    }

    public int getModifiedValue(int n) {
        return this.model.getModifiedValue(n);
    }

    public Icon getModifiedIcon(Icon icon) {
        return this.model.getModifiedIcon(icon);
    }
}

