/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.Game;
import net.sf.hale.entity.Container;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.LootList;
import net.sf.hale.entity.OpenableTemplate;
import net.sf.hale.util.SimpleJSONObject;

public class ContainerTemplate
extends OpenableTemplate {
    private final ItemList defaultItems;
    private final LootList loot;
    private final boolean isWorkbench;

    public ContainerTemplate(String string, SimpleJSONObject simpleJSONObject) {
        super(string, simpleJSONObject);
        this.loot = simpleJSONObject.containsKey("loot") ? new LootList(simpleJSONObject.getArray("loot")) : null;
        this.isWorkbench = simpleJSONObject.get("isWorkbench", false);
        this.defaultItems = simpleJSONObject.containsKey("defaultItems") ? new ItemList(simpleJSONObject.getArray("defaultItems")) : new ItemList();
    }

    @Override
    public Container createInstance() {
        return new Container(this);
    }

    public ItemList getDefaultItems() {
        return new ItemList(this.defaultItems);
    }

    public ItemList generateLoot() {
        if (this.loot == null) {
            return new ItemList();
        }
        return this.loot.generate();
    }

    public boolean isWorkbench() {
        return this.isWorkbench;
    }

    public boolean isTemporary() {
        return this.getID().equals(Game.ruleset.getString("TemporaryContainerID"));
    }
}

