/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.entity;

import net.sf.hale.area.Area;
import net.sf.hale.entity.ContainerTemplate;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Door;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.Openable;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.util.SimpleJSONObject;

public class Container
extends Openable {
    private final ContainerTemplate template;
    private final ItemList currentItems;
    private boolean lootGenerated;

    @Override
    public void load(SimpleJSONObject simpleJSONObject, Area area, ReferenceHandler referenceHandler) throws LoadGameException {
        super.load(simpleJSONObject, area, referenceHandler);
        this.lootGenerated = simpleJSONObject.get("lootGenerated", false);
        this.currentItems.load(simpleJSONObject.getArray("currentItems"));
    }

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("lootGenerated", this.lootGenerated);
        jSONOrderedObject.put("currentItems", this.currentItems.save());
        return jSONOrderedObject;
    }

    protected Container(ContainerTemplate containerTemplate) {
        super(containerTemplate);
        this.template = containerTemplate;
        this.currentItems = containerTemplate.getDefaultItems();
        this.lootGenerated = false;
    }

    @Override
    public ContainerTemplate getTemplate() {
        return this.template;
    }

    @Override
    public boolean attemptOpen(Creature creature) {
        boolean bl = super.attemptOpen(creature);
        if (bl && !this.lootGenerated) {
            this.currentItems.addAll(this.template.generateLoot());
            this.lootGenerated = true;
        }
        return bl;
    }

    public ItemList getCurrentItems() {
        return this.currentItems;
    }

    @Override
    public int compareTo(Entity entity) {
        if (entity instanceof Creature) {
            return -1;
        }
        if (entity instanceof Door) {
            return -1;
        }
        return super.compareTo(entity);
    }
}

